/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.checkstyle.CheckStyleDescriptor;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.checkstyle.CheckStyleResultBuilder;
import hudson.plugins.checkstyle.parser.CheckStyleParser;
import hudson.plugins.checkstyle.util.BuildResult;
import hudson.plugins.checkstyle.util.FilesParser;
import hudson.plugins.checkstyle.util.HealthAwarePublisher;
import hudson.plugins.checkstyle.util.ParserResult;
import hudson.plugins.checkstyle.util.PluginLogger;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStylePublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 6369581633551160418L;
    private static final String DEFAULT_PATTERN = "**/checkstyle-result.xml";
    public static final CheckStyleDescriptor CHECKSTYLE_DESCRIPTOR = new CheckStyleDescriptor();
    private final String pattern;

    @DataBoundConstructor
    public CheckStylePublisher(String pattern, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String height, String thresholdLimit, String defaultEncoding) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, height, thresholdLimit, defaultEncoding, "CHECKSTYLE");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CheckStyleProjectAction(project, this.getTrendHeight());
    }

    @Override
    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting checkstyle analysis files...");
        FilesParser parser = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), new CheckStyleParser(this.getDefaultEncoding()), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)parser);
        CheckStyleResult result = new CheckStyleResultBuilder().build(build, project, this.getDefaultEncoding());
        build.getActions().add(new CheckStyleResultAction(build, this, result));
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return CHECKSTYLE_DESCRIPTOR;
    }
}

