/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.plugins.checkstyle.util.AnnotationParser;
import hudson.plugins.checkstyle.util.FileFinder;
import hudson.plugins.checkstyle.util.Messages;
import hudson.plugins.checkstyle.util.ModuleDetector;
import hudson.plugins.checkstyle.util.ParserResult;
import hudson.plugins.checkstyle.util.PluginLogger;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesParser
implements FilePath.FileCallable<ParserResult> {
    private static final long serialVersionUID = -6415863872891783891L;
    @SuppressWarnings(value={"Se"})
    private final transient PluginLogger logger;
    private final String filePattern;
    private final AnnotationParser parser;
    private final boolean isMavenBuild;
    private final boolean isAntBuild;

    public FilesParser(PluginLogger logger, String filePattern, AnnotationParser parser, boolean isMavenBuild, boolean isAntBuild) {
        this.logger = logger;
        this.filePattern = filePattern;
        this.parser = parser;
        this.isMavenBuild = isMavenBuild;
        this.isAntBuild = isAntBuild;
    }

    protected void log(String message) {
        if (this.logger != null) {
            this.logger.log(message);
        }
    }

    public ParserResult invoke(File workspace, VirtualChannel channel) throws IOException {
        ParserResult result = new ParserResult(new FilePath(workspace));
        try {
            String[] fileNames = new FileFinder(this.filePattern).find(workspace);
            if (fileNames.length == 0 && !this.isMavenBuild) {
                result.addErrorMessage(Messages.FilesParser_Error_NoFiles());
            } else {
                this.parseFiles(workspace, fileNames, result);
            }
        }
        catch (InterruptedException exception) {
            this.log("Parsing has been canceled.");
        }
        return result;
    }

    private void parseFiles(File workspace, String[] fileNames, ParserResult result) throws InterruptedException {
        ModuleDetector detector = new ModuleDetector();
        for (String fileName : fileNames) {
            String message;
            File file = new File(workspace, fileName);
            String moduleName = detector.guessModuleName(file.getAbsolutePath(), this.isMavenBuild, this.isAntBuild);
            if (!file.canRead()) {
                message = Messages.FilesParser_Error_NoPermission((Object)moduleName, (Object)file);
                this.log(message);
                result.addErrorMessage(moduleName, message);
                continue;
            }
            if (file.length() <= 0L) {
                message = Messages.FilesParser_Error_EmptyFile((Object)moduleName, (Object)file);
                this.log(message);
                result.addErrorMessage(moduleName, message);
                continue;
            }
            this.parseFile(file, moduleName, result);
            result.addModule(moduleName);
        }
    }

    private void parseFile(File file, String moduleName, ParserResult result) throws InterruptedException {
        try {
            Collection annotations = this.parser.parse(file, moduleName);
            result.addAnnotations(annotations);
            this.log("Successfully parsed file " + file + " of module " + moduleName + " with " + annotations.size() + " warnings.");
        }
        catch (InvocationTargetException exception) {
            String errorMessage = Messages.FilesParser_Error_Exception((Object)file) + "\n\n" + ExceptionUtils.getStackTrace((Throwable)((Throwable)ObjectUtils.defaultIfNull((Object)exception.getCause(), (Object)exception)));
            result.addErrorMessage(moduleName, errorMessage);
            this.log(errorMessage);
        }
    }
}

