/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.model.Result;
import hudson.plugins.checkstyle.util.HealthDescriptor;
import hudson.plugins.checkstyle.util.ParserResult;
import hudson.plugins.checkstyle.util.PluginLogger;
import hudson.plugins.checkstyle.util.ThresholdValidator;
import hudson.plugins.checkstyle.util.model.FileAnnotation;
import hudson.plugins.checkstyle.util.model.Priority;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultEvaluator {
    public Result evaluateBuildResult(PluginLogger logger, HealthDescriptor descriptor, Collection<FileAnnotation> allAnnotations, Collection<FileAnnotation> newAnnotations) {
        ParserResult result = new ParserResult(allAnnotations);
        ParserResult newResult = new ParserResult(newAnnotations);
        int annotationCount = 0;
        int newAnnotationCount = 0;
        for (Priority priority : Priority.collectPrioritiesFrom(descriptor.getMinimumPriority())) {
            annotationCount += result.getNumberOfAnnotations(priority);
            newAnnotationCount += newResult.getNumberOfAnnotations(priority);
        }
        logger.log(String.format("Found %d annotations (%d new, %d high, %d normal, %d low)", result.getNumberOfAnnotations(), newAnnotationCount, result.getNumberOfAnnotations(Priority.HIGH), result.getNumberOfAnnotations(Priority.NORMAL), result.getNumberOfAnnotations(Priority.LOW)));
        if (descriptor.getMinimumPriority() != Priority.LOW) {
            logger.log(String.format("Considering %d annotations for build status evaluation", annotationCount));
            logger.log(String.format("Considering %d new annotations for build status evaluation", newAnnotationCount));
        }
        if (this.isAnnotationCountExceeded(annotationCount, descriptor.getFailureThreshold())) {
            logger.log("Setting build status to FAILURE since total number of annotations exceeds the threshold " + descriptor.getFailureThreshold());
            return Result.FAILURE;
        }
        if (this.isAnnotationCountExceeded(newAnnotationCount, descriptor.getNewFailureThreshold())) {
            logger.log("Setting build status to FAILURE since total number of new annotations exceeds the threshold " + descriptor.getNewFailureThreshold());
            return Result.FAILURE;
        }
        if (this.isAnnotationCountExceeded(annotationCount, descriptor.getThreshold())) {
            logger.log("Setting build status to UNSTABLE since total number of annotations exceeds the threshold " + descriptor.getThreshold());
            return Result.UNSTABLE;
        }
        if (this.isAnnotationCountExceeded(newAnnotationCount, descriptor.getNewThreshold())) {
            logger.log("Setting build status to UNSTABLE since total number of new annotations exceeds the threshold " + descriptor.getNewThreshold());
            return Result.UNSTABLE;
        }
        logger.log("Not changing build status, since no threshold has been exceeded");
        return Result.SUCCESS;
    }

    public boolean isAnnotationCountExceeded(int annotationCount, String annotationThreshold) {
        if (annotationCount > 0 && ThresholdValidator.isValid(annotationThreshold)) {
            return annotationCount > ThresholdValidator.convert(annotationThreshold);
        }
        return false;
    }
}

