/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import com.thoughtworks.xstream.XStream;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.checkstyle.Messages;
import hudson.plugins.checkstyle.ResultSummary;
import hudson.plugins.checkstyle.parser.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStyleResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public CheckStyleResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public CheckStyleResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, CheckStyleResult previous) {
        super(build, defaultEncoding, result, (BuildResult)previous);
    }

    protected void configure(XStream xstream) {
        xstream.alias("warning", Warning.class);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage(this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.Checkstyle_ResultAction_NoWarningsSince(this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = CheckStyleResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.Checkstyle_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.Checkstyle_ResultAction_MultipleHighScore(days) + "</li>";
        }
        long days = CheckStyleResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.Checkstyle_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.Checkstyle_ResultAction_MultipleNoHighScore(days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "checkstyle-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.Checkstyle_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return CheckStyleResultAction.class;
    }
}

