/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.checkstyle.CheckStyleDescriptor;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.checkstyle.parser.CheckStyleParser;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStylePublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 6369581633551160418L;
    private static final String DEFAULT_PATTERN = "**/checkstyle-result.xml";
    private final String pattern;

    @DataBoundConstructor
    public CheckStylePublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, String pattern) {
        super(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, "CHECKSTYLE");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CheckStyleProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting checkstyle analysis files...");
        FilesParser parser = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), (AnnotationParser)new CheckStyleParser(this.getDefaultEncoding()), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)parser);
        CheckStyleResult result = new CheckStyleResult(build, this.getDefaultEncoding(), project);
        build.getActions().add(new CheckStyleResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public CheckStyleDescriptor getDescriptor() {
        return (CheckStyleDescriptor)super.getDescriptor();
    }
}

