/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.rules;

import hudson.plugins.checkstyle.rules.Rule;
import hudson.plugins.checkstyle.rules.Topic;
import hudson.plugins.checkstyle.rules.TopicRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckStyleRules {
    private final Map<String, Rule> rulesByName = new HashMap();
    private static final CheckStyleRules INSTANCE = new CheckStyleRules();

    public static CheckStyleRules getInstance() {
        return INSTANCE;
    }

    private CheckStyleRules() {
    }

    public void initialize() {
        try {
            String[] ruleFiles = new String[]{"annotation", "coding", "design", "duplicates", "header", "imports", "javadoc", "metrics", "misc", "modifier", "naming", "regexp", "sizes", "whitespace"};
            for (int i = 0; i < ruleFiles.length; ++i) {
                InputStream inputStream = CheckStyleRules.class.getResourceAsStream("config_" + ruleFiles[i] + ".xml");
                Digester digester = this.createDigester();
                ArrayList rules = new ArrayList();
                digester.push(rules);
                digester.parse(inputStream);
                for (Rule rule : rules) {
                    this.rulesByName.put(rule.getName(), rule);
                }
            }
        }
        catch (ParserConfigurationException exception) {
            this.log((Throwable)exception);
        }
        catch (IOException exception) {
            this.log((Throwable)exception);
        }
        catch (SAXException exception) {
            this.log((Throwable)exception);
        }
    }

    private void log(Throwable exception) {
        Logger.getLogger(CheckStyleRules.class.getName()).log(Level.SEVERE, "Can't initialize checkstyle rules.", exception);
    }

    private Digester createDigester() throws ParserConfigurationException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(CheckStyleRules.class.getClassLoader());
        String section = "*/section";
        digester.addObjectCreate(section, Rule.class);
        digester.addSetProperties(section);
        digester.addSetNext(section, "add");
        String subSection = "*/section/subsection";
        digester.addObjectCreate(subSection, Topic.class);
        digester.addSetProperties(subSection);
        digester.addSetNext(subSection, "setDescription");
        digester.addRule(subSection, (org.apache.commons.digester.Rule)new TopicRule());
        return digester;
    }

    public Collection<Rule> getRules() {
        return Collections.unmodifiableCollection(this.rulesByName.values());
    }

    public Rule getRule(String name) {
        Rule rule = (Rule)this.rulesByName.get(name);
        if (rule == null) {
            rule = (Rule)this.rulesByName.get(StringUtils.removeEnd((String)name, (String)"Check"));
        }
        if (rule == null) {
            return new Rule(name);
        }
        return rule;
    }

    public String getDescription(String name) {
        return this.getRule(name).getDescription();
    }
}

