/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareMavenReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.MavenCheckStyleResultAction;
import hudson.plugins.checkstyle.parser.CheckStyleParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStyleReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = 2272875032054063496L;
    private static final String CHECKSTYLE_XML_FILE = "checkstyle-result.xml";

    @DataBoundConstructor
    public CheckStyleReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, boolean canRunOnFailed) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, canRunOnFailed, "CHECKSTYLE");
    }

    protected boolean acceptGoal(String goal) {
        return "checkstyle".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilesParser checkstyleCollector = new FilesParser(logger, CHECKSTYLE_XML_FILE, (AnnotationParser)new CheckStyleParser(this.getDefaultEncoding()), this.getModuleName(pom));
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)checkstyleCollector);
    }

    protected CheckStyleResult persistResult(ParserResult project, MavenBuild build) {
        CheckStyleResult result = new CheckStyleResult((AbstractBuild)build, this.getDefaultEncoding(), project);
        build.getActions().add(new MavenCheckStyleResultAction((AbstractBuild)build, (HealthDescriptor)this, this.getDefaultEncoding(), result));
        build.registerAsProjectAction((MavenReporter)this);
        return result;
    }

    public List<CheckStyleProjectAction> getProjectActions(MavenModule module) {
        return Collections.singletonList(new CheckStyleProjectAction((AbstractProject)module));
    }

    protected Class<? extends Action> getResultActionClass() {
        return MavenCheckStyleResultAction.class;
    }
}

