/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.chucknorris;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.chucknorris.FactGenerator;
import hudson.plugins.chucknorris.RoundhouseAction;
import hudson.plugins.chucknorris.Style;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CordellWalkerRecorder
extends Recorder {
    private static final Logger LOGGER = Logger.getLogger(CordellWalkerRecorder.class.getName());
    private FactGenerator factGenerator;

    @DataBoundConstructor
    public CordellWalkerRecorder() {
        this(new FactGenerator());
    }

    public CordellWalkerRecorder(FactGenerator factGenerator) {
        this.factGenerator = factGenerator;
        LOGGER.info("Chuck Norris is activated");
    }

    public Action getProjectAction(Project project) {
        RoundhouseAction action = null;
        if (project.getLastBuild() != null) {
            Style style = Style.get((Result)project.getLastBuild().getResult());
            String fact = this.factGenerator.random();
            action = new RoundhouseAction(style, fact);
        }
        return action;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Style style = Style.get((Result)build.getResult());
        String fact = this.factGenerator.random();
        build.getActions().add(new RoundhouseAction(style, fact));
        return true;
    }
}

