/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.basic;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.cigame.model.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultRule
implements Rule {
    private int failurePoints = -10;
    private int successPoints = 1;

    public BuildResultRule() {
    }

    public BuildResultRule(int successPoints, int failurePoints) {
        this.successPoints = successPoints;
        this.failurePoints = failurePoints;
    }

    public String getName() {
        return "Build result";
    }

    public double evaluate(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        if (result == Result.SUCCESS) {
            return this.successPoints;
        }
        if (result == Result.FAILURE) {
            Result lastResult = Result.SUCCESS;
            Run previousBuild = build.getPreviousBuild();
            if (previousBuild != null) {
                lastResult = previousBuild.getResult();
            }
            if (result.isWorseThan(lastResult)) {
                return this.failurePoints;
            }
        }
        return 0.0;
    }
}

