/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.basic;

import hudson.model.AbstractBuild;
import hudson.plugins.cigame.model.Rule;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncreasingPassedTestsRule
implements Rule {
    private int pointsForEachFixedFailure = 1;

    public double evaluate(AbstractBuild<?, ?> build) {
        TestResultAction action = (TestResultAction)build.getAction(TestResultAction.class);
        if (action != null && action.getPreviousResult() != null) {
            TestResult currentResult = action.getResult();
            TestResult previousResult = ((TestResultAction)action.getPreviousResult()).getResult();
            int passedTestDiff = currentResult.getPassCount() - previousResult.getPassCount();
            if (passedTestDiff > 0) {
                return passedTestDiff * this.pointsForEachFixedFailure;
            }
        }
        return 0.0;
    }

    public String getName() {
        return "Increased number of passed tests";
    }
}

