/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.cigame.LeaderBoardAction;
import hudson.plugins.cigame.PluginImpl;
import hudson.plugins.cigame.ScoreCardAction;
import hudson.plugins.cigame.UserScoreProperty;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleSet;
import hudson.plugins.cigame.model.ScoreCard;
import hudson.plugins.cigame.rules.basic.BuildResultRule;
import hudson.plugins.cigame.rules.basic.IncreasingFailedTestsRule;
import hudson.plugins.cigame.rules.basic.IncreasingPassedTestsRule;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamePublisher
extends Publisher {
    public Descriptor<Publisher> getDescriptor() {
        return PluginImpl.getDescriptor();
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        RuleSet ruleset = new RuleSet("Basic ruleset", new LinkedList<Rule>());
        ruleset.add(new BuildResultRule());
        ruleset.add(new IncreasingFailedTestsRule());
        ruleset.add(new IncreasingPassedTestsRule());
        ScoreCard sc = new ScoreCard();
        sc.record(build, ruleset);
        ScoreCardAction action = new ScoreCardAction(sc, build);
        build.getActions().add(action);
        if (this.updateUserScores((ChangeLogSet<? extends ChangeLogSet.Entry>)build.getChangeSet(), sc.getTotalPoints())) {
            this.installLeaderBoard();
        }
        return true;
    }

    private boolean updateUserScores(ChangeLogSet<? extends ChangeLogSet.Entry> changeSet, double score) throws IOException {
        HashSet<User> players = new HashSet<User>();
        if (score != 0.0) {
            for (ChangeLogSet.Entry entry : changeSet) {
                players.add(entry.getAuthor());
            }
            for (User user : players) {
                UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
                if (property == null) {
                    property = new UserScoreProperty();
                    user.addProperty((UserProperty)property);
                }
                property.setScore(property.getScore() + score);
                user.save();
            }
        }
        return !players.isEmpty();
    }

    private void installLeaderBoard() {
        boolean isInstalled = false;
        List installedActions = Hudson.getInstance().getActions();
        for (Action installedAction : installedActions) {
            if (!(installedAction instanceof LeaderBoardAction)) continue;
            isInstalled = true;
            break;
        }
        if (!isInstalled) {
            LeaderBoardAction action = new LeaderBoardAction();
            Hudson.getInstance().getActions().add(action);
        }
    }
}

