/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.model.Action;
import hudson.model.User;
import hudson.plugins.cigame.UserScoreProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class LeaderBoardAction
implements Action {
    private static final long serialVersionUID = 1L;

    public String getDisplayName() {
        return "Leader board";
    }

    public String getIconFileName() {
        return "/plugin/ci-game/icons/game-22x22.png";
    }

    public String getUrlName() {
        return "cigame";
    }

    @Exported
    public List<UserScore> getUserScores() {
        ArrayList<UserScore> list = new ArrayList<UserScore>();
        for (User user : User.getAll()) {
            UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
            if (property == null) continue;
            list.add(new UserScore(property.getUser(), property.getScore()));
        }
        Collections.sort(list, new Comparator<UserScore>(){

            @Override
            public int compare(UserScore o1, UserScore o2) {
                if (o1.score < o2.score) {
                    return 1;
                }
                if (o1.score > o2.score) {
                    return -1;
                }
                return 0;
            }
        });
        return list;
    }

    @ExportedBean(defaultVisibility=999)
    public class UserScore {
        private User user;
        private double score;

        public UserScore(User user, double score) {
            this.user = user;
            this.score = score;
        }

        @Exported
        public User getUser() {
            return this.user;
        }

        @Exported
        public double getScore() {
            return this.score;
        }
    }
}

