/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.model;

import hudson.model.AbstractBuild;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleSet;
import hudson.plugins.cigame.model.Score;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreCard {
    private Collection<Score> scores;

    public void record(AbstractBuild<?, ?> build, RuleSet ruleset) {
        if (this.scores == null) {
            this.scores = new LinkedList();
        }
        for (Rule rule : ruleset.getRules()) {
            double points = rule.evaluate(build);
            if (points == 0.0) continue;
            Score score = new Score(ruleset.getName(), rule.getName(), points);
            this.scores.add(score);
        }
    }

    public Collection<Score> getScores() throws IllegalStateException {
        if (this.scores == null) {
            throw new IllegalStateException("No scores are available");
        }
        return this.scores;
    }

    public double getTotalPoints() throws IllegalStateException {
        if (this.scores == null) {
            throw new IllegalStateException("No scores are available");
        }
        double value = 0.0;
        for (Score score : this.scores) {
            value += score.getValue();
        }
        return value;
    }
}

