/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.basic;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.tasks.junit.TestResultAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncreasingFailedTestsRule
implements Rule {
    private double pointsForEachNewFailure;

    public IncreasingFailedTestsRule() {
        this(-1);
    }

    public IncreasingFailedTestsRule(int points) {
        this.pointsForEachNewFailure = points;
    }

    public String getName() {
        return "Increased number of failed tests";
    }

    public double evaluate(AbstractBuild<?, ?> build) {
        TestResultAction action = (TestResultAction)build.getAction(TestResultAction.class);
        if (action != null && action.getPreviousResult() != null) {
            return this.evaluate(build.getResult(), ((AbstractBuild)build.getPreviousBuild()).getResult(), action.getResult().getFailCount(), ((TestResultAction)action.getPreviousResult()).getResult().getFailCount());
        }
        return 0.0;
    }

    double evaluate(Result currentResult, Result previousResult, int currentFailCount, int previousFailCount) {
        int failingTestDiff;
        if (previousResult.isBetterThan(Result.FAILURE) && currentResult.isBetterOrEqualTo(Result.UNSTABLE) && (failingTestDiff = currentFailCount - previousFailCount) > 0) {
            return (double)failingTestDiff * this.pointsForEachNewFailure;
        }
        return 0.0;
    }
}

