/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.checkstyle;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCheckstyleRule
implements Rule {
    private int pointsForAddingAWarning;
    private int pointsForRemovingAWarning;

    public DefaultCheckstyleRule(int pointsForAddingAWarning, int pointsForRemovingAWarning) {
        this.pointsForAddingAWarning = pointsForAddingAWarning;
        this.pointsForRemovingAWarning = pointsForRemovingAWarning;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        int numberOfWarnings = 0;
        if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) && build.getPreviousBuild() != null) {
            List actions = build.getActions(CheckStyleResultAction.class);
            for (CheckStyleResultAction action : actions) {
                if (!action.hasPreviousResultAction()) continue;
                CheckStyleResult result = (CheckStyleResult)action.getResult();
                CheckStyleResult previousResult = (CheckStyleResult)action.getPreviousResultAction().getResult();
                Collection annotations = result.getAnnotations();
                Collection previousAnnotations = previousResult.getAnnotations();
                if (annotations == null || previousAnnotations == null) continue;
                numberOfWarnings += annotations.size() - previousAnnotations.size();
            }
        }
        if (numberOfWarnings > 0) {
            return new RuleResult((double)(numberOfWarnings * this.pointsForAddingAWarning), String.format("%d new checkstyle warningss were found", numberOfWarnings));
        }
        if (numberOfWarnings < 0) {
            return new RuleResult((double)(numberOfWarnings * -1 * this.pointsForRemovingAWarning), String.format("%d checkstyle warnings were fixed", numberOfWarnings * -1));
        }
        return new RuleResult(0.0, "No new or fixed checkstyle warnings found.");
    }

    public String getName() {
        return "Changed number of checkstyle warnings";
    }
}

