/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.opentasks;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.util.model.Priority;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOpenTasksRule
implements Rule {
    private int pointsForAddingAnAnnotation;
    private int pointsForRemovingAnAnnotation;
    private Priority tasksPriority;

    public DefaultOpenTasksRule(Priority tasksPriority, int pointsForAddingAnAnnotation, int pointsForRemovingAnAnnotation) {
        this.tasksPriority = tasksPriority;
        this.pointsForAddingAnAnnotation = pointsForAddingAnAnnotation;
        this.pointsForRemovingAnAnnotation = pointsForRemovingAnAnnotation;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        int numberOfAnnotations = 0;
        if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) && build.getPreviousBuild() != null) {
            List actions = build.getActions(TasksResultAction.class);
            for (TasksResultAction action : actions) {
                if (!action.hasPreviousResultAction()) continue;
                TasksResult result = (TasksResult)action.getResult();
                TasksResult previousResult = (TasksResult)action.getPreviousResultAction().getResult();
                Collection annotations = result.getAnnotations(this.tasksPriority.name());
                Collection previousAnnotations = previousResult.getAnnotations(this.tasksPriority.name());
                if (annotations == null || previousAnnotations == null) continue;
                numberOfAnnotations += annotations.size() - previousAnnotations.size();
            }
        }
        if (numberOfAnnotations > 0) {
            return new RuleResult((double)(numberOfAnnotations * this.pointsForAddingAnAnnotation), String.format("%d new open %s priority tasks were found", numberOfAnnotations, this.tasksPriority.name()));
        }
        if (numberOfAnnotations < 0) {
            return new RuleResult((double)(numberOfAnnotations * -1 * this.pointsForRemovingAnAnnotation), String.format("%d open %s priority tasks were fixed", numberOfAnnotations * -1, this.tasksPriority.name()));
        }
        return new RuleResult(0.0, String.format("No new or fixed %s priority tasks found.", this.tasksPriority.name()));
    }

    public String getName() {
        return String.format("Open %s priority tasks", this.tasksPriority.name());
    }
}

