/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.violation;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsReport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViolationRule
implements Rule {
    private int pointsForAddingViolation;
    private int pointsForRemovingViolation;
    private String typeName;
    private String violationName;

    public DefaultViolationRule(String typeName, String violationName, int pointsForAddingViolation, int pointsForRemovingViolation) {
        this.typeName = typeName;
        this.violationName = violationName;
        this.pointsForAddingViolation = pointsForAddingViolation;
        this.pointsForRemovingViolation = pointsForRemovingViolation;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        int diff = 0;
        if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) && build.getPreviousBuild() != null) {
            List actions = build.getActions(ViolationsBuildAction.class);
            for (ViolationsBuildAction action : actions) {
                ViolationsReport violationReport = action.getReport();
                if (violationReport.previous() == null) continue;
                ViolationsReport.TypeReport typeReport = (ViolationsReport.TypeReport)violationReport.getTypeReports().get(this.typeName);
                ViolationsReport.TypeReport previousTypeReport = (ViolationsReport.TypeReport)violationReport.previous().getTypeReports().get(this.typeName);
                if (typeReport == null || previousTypeReport == null) continue;
                diff += typeReport.getNumber() - previousTypeReport.getNumber();
            }
        }
        if (diff > 0) {
            return new RuleResult((double)(diff * this.pointsForAddingViolation), String.format("%d new %ss were found", diff, this.violationName));
        }
        if (diff < 0) {
            return new RuleResult((double)(diff * -1 * this.pointsForRemovingViolation), String.format("%d %ss were fixed", diff * -1, this.violationName));
        }
        return new RuleResult(0.0, String.format("There was no change for %ss", this.violationName));
    }

    protected double evaluateReport(ViolationsReport report, ViolationsReport previousReport) {
        ViolationsReport.TypeReport typeReport = (ViolationsReport.TypeReport)report.getTypeReports().get(this.typeName);
        ViolationsReport.TypeReport previousTypeReport = (ViolationsReport.TypeReport)previousReport.getTypeReports().get(this.typeName);
        if (typeReport != null && previousReport != null) {
            int diff = typeReport.getNumber() - previousTypeReport.getNumber();
            if (diff > 0) {
                return this.pointsForAddingViolation;
            }
            if (diff < 0) {
                return this.pointsForRemovingViolation;
            }
        }
        return 0.0;
    }

    public String getName() {
        return this.violationName;
    }
}

