/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncreasingPassedTestsRule
implements Rule {
    private int pointsForEachFixedFailure;

    public IncreasingPassedTestsRule() {
        this(1);
    }

    public IncreasingPassedTestsRule(int points) {
        this.pointsForEachFixedFailure = points;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List actions = build.getActions(AbstractTestResultAction.class);
        for (AbstractTestResultAction action : actions) {
            if (action == null || action.getPreviousResult() == null) continue;
            return this.evaluate(build.getResult(), ((AbstractBuild)build.getPreviousBuild()).getResult(), action.getTotalCount() - action.getFailCount(), action.getPreviousResult().getTotalCount() - action.getPreviousResult().getFailCount());
        }
        return null;
    }

    RuleResult evaluate(Result currentResult, Result previousResult, int currentPassCount, int previousPassCount) {
        int passedTestDiff;
        if (previousResult.isBetterThan(Result.FAILURE) && currentResult.isBetterOrEqualTo(Result.UNSTABLE) && (passedTestDiff = currentPassCount - previousPassCount) > 0) {
            return new RuleResult((double)(passedTestDiff * this.pointsForEachFixedFailure), String.format("%d failing tests were fixed", passedTestDiff));
        }
        return null;
    }

    public String getName() {
        return "Increased number of passed tests";
    }
}

