/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.checkstyle;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCheckstyleRule
implements Rule {
    private int pointsForAddingAWarning;
    private int pointsForRemovingAWarning;

    public DefaultCheckstyleRule(int pointsForAddingAWarning, int pointsForRemovingAWarning) {
        this.pointsForAddingAWarning = pointsForAddingAWarning;
        this.pointsForRemovingAWarning = pointsForRemovingAWarning;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List sequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (sequence = new ActionSequenceRetriever(CheckStyleResultAction.class, 2).getSequence(build)) != null) {
            int numberOfWarnings = this.getNumberOfAnnotations((List)sequence.get(0)) - this.getNumberOfAnnotations((List)sequence.get(1));
            if (numberOfWarnings > 0) {
                return new RuleResult((double)(numberOfWarnings * this.pointsForAddingAWarning), String.format("%d new checkstyle warningss were found", numberOfWarnings));
            }
            if (numberOfWarnings < 0) {
                return new RuleResult((double)(numberOfWarnings * -1 * this.pointsForRemovingAWarning), String.format("%d checkstyle warnings were fixed", numberOfWarnings * -1));
            }
        }
        return new RuleResult(0.0, "No new or fixed checkstyle warnings found.");
    }

    private int getNumberOfAnnotations(List<CheckStyleResultAction> actions) {
        int numberOfAnnotations = 0;
        for (CheckStyleResultAction action : actions) {
            numberOfAnnotations += ((CheckStyleResult)action.getResult()).getNumberOfAnnotations();
        }
        return numberOfAnnotations;
    }

    public String getName() {
        return "Changed number of checkstyle warnings";
    }
}

