/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFindBugsWarningsRule
implements Rule {
    private Priority priority;
    private int pointsForEachNewWarning;

    public NewFindBugsWarningsRule(Priority priority, int pointsForEachNewWarning) {
        this.priority = priority;
        this.pointsForEachNewWarning = pointsForEachNewWarning;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List actionSequence;
        int numberOfAnnotations = 0;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (actionSequence = new ActionSequenceRetriever(FindBugsResultAction.class, 2).getSequence(build)) != null) {
            numberOfAnnotations = this.getNumberOfAnnotations((List)actionSequence.get(0)) - this.getNumberOfAnnotations((List)actionSequence.get(1));
        }
        if (numberOfAnnotations > 0) {
            return new RuleResult((double)(numberOfAnnotations * this.pointsForEachNewWarning), String.format("%d new %s priority findbugs warnings were found", Math.abs(numberOfAnnotations), this.priority.name()));
        }
        return new RuleResult(0.0, String.format("No new %s priority findbugs warnings found.", this.priority.name()));
    }

    private int getNumberOfAnnotations(List<FindBugsResultAction> list) {
        int numberOfAnnotations = 0;
        for (FindBugsResultAction action : list) {
            numberOfAnnotations += ((FindBugsResult)action.getResult()).getNumberOfAnnotations(this.priority);
        }
        return numberOfAnnotations;
    }

    public String getName() {
        return String.format("New %s priority Findbugs warnings", this.priority.name());
    }
}

