/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.opentasks;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOpenTasksRule
implements Rule {
    private int pointsForAddingAnAnnotation;
    private int pointsForRemovingAnAnnotation;
    private Priority tasksPriority;

    public DefaultOpenTasksRule(Priority tasksPriority, int pointsForAddingAnAnnotation, int pointsForRemovingAnAnnotation) {
        this.tasksPriority = tasksPriority;
        this.pointsForAddingAnAnnotation = pointsForAddingAnAnnotation;
        this.pointsForRemovingAnAnnotation = pointsForRemovingAnAnnotation;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List actionSequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (actionSequence = new ActionSequenceRetriever(TasksResultAction.class, 2).getSequence(build)) != null) {
            int numberOfAnnotations = this.getNumberOfAnnotations((List)actionSequence.get(0)) - this.getNumberOfAnnotations((List)actionSequence.get(1));
            if (numberOfAnnotations > 0) {
                return new RuleResult((double)(numberOfAnnotations * this.pointsForAddingAnAnnotation), String.format("%d new open %s priority tasks were found", numberOfAnnotations, this.tasksPriority.name()));
            }
            if (numberOfAnnotations < 0) {
                return new RuleResult((double)(numberOfAnnotations * -1 * this.pointsForRemovingAnAnnotation), String.format("%d open %s priority tasks were fixed", numberOfAnnotations * -1, this.tasksPriority.name()));
            }
        }
        return new RuleResult(0.0, String.format("No new or fixed %s priority tasks found.", this.tasksPriority.name()));
    }

    private int getNumberOfAnnotations(List<TasksResultAction> actions) {
        int numberOfAnnotations = 0;
        for (TasksResultAction action : actions) {
            numberOfAnnotations += ((TasksResult)action.getResult()).getAnnotations(this.tasksPriority.name()).size();
        }
        return numberOfAnnotations;
    }

    public String getName() {
        return String.format("Open %s priority tasks", this.tasksPriority.name());
    }
}

