/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.warnings;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWarningsRule
implements Rule {
    private int pointsForAddingAWarning;
    private int pointsForRemovingAWarning;

    public DefaultWarningsRule(int pointsForAddingAWarning, int pointsForRemovingAWarning) {
        this.pointsForAddingAWarning = pointsForAddingAWarning;
        this.pointsForRemovingAWarning = pointsForRemovingAWarning;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List sequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (sequence = new ActionSequenceRetriever(WarningsResultAction.class, 2).getSequence(build)) != null) {
            int numberOfAnnotations = this.getNumberOfAnnotations((List)sequence.get(0)) - this.getNumberOfAnnotations((List)sequence.get(1));
            if (numberOfAnnotations > 0) {
                return new RuleResult((double)(numberOfAnnotations * this.pointsForAddingAWarning), String.format("%d new compiler warnings were found", numberOfAnnotations));
            }
            if (numberOfAnnotations < 0) {
                return new RuleResult((double)(numberOfAnnotations * -1 * this.pointsForRemovingAWarning), String.format("%d compiler warnings were fixed", numberOfAnnotations * -1));
            }
        }
        return new RuleResult(0.0, "No new or fixed compiler warnings found.");
    }

    private int getNumberOfAnnotations(List<WarningsResultAction> actions) {
        int numberOfAnnotations = 0;
        for (WarningsResultAction action : actions) {
            numberOfAnnotations += ((WarningsResult)action.getResult()).getNumberOfAnnotations();
        }
        return numberOfAnnotations;
    }

    public String getName() {
        return "Changed number of compiler warnings";
    }
}

