/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.model;

import hudson.model.AbstractBuild;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleBook;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.model.RuleSet;
import hudson.plugins.cigame.model.Score;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class ScoreCard {
    private List<Score> scores;

    public void record(AbstractBuild<?, ?> build, RuleSet ruleset) {
        if (this.scores == null) {
            this.scores = new LinkedList<Score>();
        }
        for (Rule rule : ruleset.getRules()) {
            RuleResult result = rule.evaluate(build);
            if (result == null || result.getPoints() == 0.0) continue;
            Score score = new Score(ruleset.getName(), rule.getName(), result.getPoints(), result.getDescription());
            this.scores.add(score);
        }
        Collections.sort(this.scores);
    }

    public void record(AbstractBuild<?, ?> build, RuleBook ruleBook) {
        for (RuleSet set : ruleBook.getRuleSets()) {
            this.record(build, set);
        }
    }

    @Exported
    public Collection<Score> getScores() throws IllegalStateException {
        if (this.scores == null) {
            throw new IllegalStateException("No scores are available");
        }
        return this.scores;
    }

    @Exported
    public double getTotalPoints() throws IllegalStateException {
        if (this.scores == null) {
            throw new IllegalStateException("No scores are available");
        }
        double value = 0.0;
        for (Score score : this.scores) {
            value += score.getValue();
        }
        return value;
    }
}

