/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.pmd;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPmdRule
implements Rule {
    private int pointsForAddingAnAnnotation;
    private int pointsForRemovingAnAnnotation;
    private Priority tasksPriority;

    public DefaultPmdRule(Priority tasksPriority, int pointsForAddingAnAnnotation, int pointsForRemovingAnAnnotation) {
        this.tasksPriority = tasksPriority;
        this.pointsForAddingAnAnnotation = pointsForAddingAnAnnotation;
        this.pointsForRemovingAnAnnotation = pointsForRemovingAnAnnotation;
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List<List<PmdResultAction>> sequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (sequence = new ActionSequenceRetriever<PmdResultAction>(PmdResultAction.class, 2).getSequence(build)) != null) {
            int delta = this.getNumberOfAnnotations(sequence.get(0)) - this.getNumberOfAnnotations(sequence.get(1));
            if (delta < 0) {
                return new RuleResult(Math.abs(delta) * this.pointsForRemovingAnAnnotation, String.format("%d %s priority PMD warnings were fixed", Math.abs(delta), this.tasksPriority.name()));
            }
            if (delta > 0) {
                return new RuleResult(Math.abs(delta) * this.pointsForAddingAnAnnotation, String.format("%d new %s priority PMD warnings were found", Math.abs(delta), this.tasksPriority.name()));
            }
        }
        return new RuleResult(0.0, String.format("No new or fixed %s priority PMD warnings found.", this.tasksPriority.name()));
    }

    private int getNumberOfAnnotations(List<PmdResultAction> actions) {
        int numberOfAnnotations = 0;
        for (PmdResultAction action : actions) {
            numberOfAnnotations += ((PmdResult)action.getResult()).getNumberOfAnnotations(this.tasksPriority);
        }
        return numberOfAnnotations;
    }

    @Override
    public String getName() {
        return String.format("%s priority PMD warnings", this.tasksPriority.name());
    }
}

