/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.violation;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsReport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViolationRule
implements Rule {
    private int pointsForAddingViolation;
    private int pointsForRemovingViolation;
    private String typeName;
    private String violationName;

    public DefaultViolationRule(String typeName, String violationName, int pointsForAddingViolation, int pointsForRemovingViolation) {
        this.typeName = typeName;
        this.violationName = violationName;
        this.pointsForAddingViolation = pointsForAddingViolation;
        this.pointsForRemovingViolation = pointsForRemovingViolation;
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List<List<ViolationsBuildAction>> actionList;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (actionList = new ActionSequenceRetriever<ViolationsBuildAction>(ViolationsBuildAction.class, 2).getSequence(build)) != null) {
            int diff = this.getTypeReportCount(actionList.get(0)) - this.getTypeReportCount(actionList.get(1));
            if (diff > 0) {
                return new RuleResult(diff * this.pointsForAddingViolation, String.format("%d new %ss were found", diff, this.violationName));
            }
            if (diff < 0) {
                return new RuleResult(diff * -1 * this.pointsForRemovingViolation, String.format("%d %ss were fixed", diff * -1, this.violationName));
            }
        }
        return new RuleResult(0.0, String.format("There was no change for %ss", this.violationName));
    }

    private int getTypeReportCount(List<ViolationsBuildAction> actions) {
        int numberOfReports = 0;
        for (ViolationsBuildAction action : actions) {
            numberOfReports += ((ViolationsReport.TypeReport)action.getReport().getTypeReports().get(this.typeName)).getNumber();
        }
        return numberOfReports;
    }

    @Override
    public String getName() {
        return this.violationName;
    }
}

