// CHECKSTYLE:OFF

package hudson.plugins.cigame.rules.unittesting;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Unit testing
     * 
     */
    public static String UnitTestingRuleSet_Title() {
        return holder.format("UnitTestingRuleSet.Title");
    }

    /**
     * Unit testing
     * 
     */
    public static Localizable _UnitTestingRuleSet_Title() {
        return new Localizable(holder, "UnitTestingRuleSet.Title");
    }

    /**
     * {0} failing tests were fixed
     * 
     */
    public static String UnitTestingRuleSet_IncreasingPassedRule_Count(Object arg1) {
        return holder.format("UnitTestingRuleSet.IncreasingPassedRule.Count", arg1);
    }

    /**
     * {0} failing tests were fixed
     * 
     */
    public static Localizable _UnitTestingRuleSet_IncreasingPassedRule_Count(Object arg1) {
        return new Localizable(holder, "UnitTestingRuleSet.IncreasingPassedRule.Count", arg1);
    }

    /**
     * Increased number of passed tests
     * 
     */
    public static String UnitTestingRuleSet_IncreasingPassedRule_Name() {
        return holder.format("UnitTestingRuleSet.IncreasingPassedRule.Name");
    }

    /**
     * Increased number of passed tests
     * 
     */
    public static Localizable _UnitTestingRuleSet_IncreasingPassedRule_Name() {
        return new Localizable(holder, "UnitTestingRuleSet.IncreasingPassedRule.Name");
    }

    /**
     * {0} new failing tests were added
     * 
     */
    public static String UnitTestingRuleSet_IncreasingFailedRule_Count(Object arg1) {
        return holder.format("UnitTestingRuleSet.IncreasingFailedRule.Count", arg1);
    }

    /**
     * {0} new failing tests were added
     * 
     */
    public static Localizable _UnitTestingRuleSet_IncreasingFailedRule_Count(Object arg1) {
        return new Localizable(holder, "UnitTestingRuleSet.IncreasingFailedRule.Count", arg1);
    }

    /**
     * Increased number of failed tests
     * 
     */
    public static String UnitTestingRuleSet_IncreasingFailedRule_Name() {
        return holder.format("UnitTestingRuleSet.IncreasingFailedRule.Name");
    }

    /**
     * Increased number of failed tests
     * 
     */
    public static Localizable _UnitTestingRuleSet_IncreasingFailedRule_Name() {
        return new Localizable(holder, "UnitTestingRuleSet.IncreasingFailedRule.Name");
    }

}
