/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.model.Hudson;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.plugins.cigame.CaseInsensitiveUserIdComparator;
import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.LeaderBoardAction;
import hudson.plugins.cigame.Messages;
import hudson.plugins.cigame.UserScoreProperty;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class LeaderBoardAction
implements RootAction,
AccessControlled {
    private static final long serialVersionUID = 1L;

    public String getDisplayName() {
        return Messages.Leaderboard_Title();
    }

    public String getIconFileName() {
        return "/plugin/ci-game/icons/game-22x22.png";
    }

    public String getUrlName() {
        return "/cigame";
    }

    @Exported
    public List<UserScore> getUserScores() {
        return this.getUserScores(User.getAll(), ((GameDescriptor)Hudson.getInstance().getDescriptorByType(GameDescriptor.class)).getNamesAreCaseSensitive());
    }

    List<UserScore> getUserScores(Collection<User> users, boolean usernameIsCasesensitive) {
        Collection<User> players;
        ArrayList<UserScore> list = new ArrayList<UserScore>();
        if (usernameIsCasesensitive) {
            players = users;
        } else {
            ArrayList<User> playerList = new ArrayList<User>();
            CaseInsensitiveUserIdComparator caseInsensitiveUserIdComparator = new CaseInsensitiveUserIdComparator();
            for (User user : users) {
                if (Collections.binarySearch(playerList, user, caseInsensitiveUserIdComparator) >= 0) continue;
                playerList.add(user);
            }
            players = playerList;
        }
        for (User user : players) {
            UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
            if (property == null || !property.isParticipatingInGame()) continue;
            list.add(new UserScore(this, user, property.getScore(), user.getDescription()));
        }
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        return list;
    }

    public void doResetScores(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (Hudson.getInstance().getACL().hasPermission(Hudson.ADMINISTER)) {
            this.doResetScores(User.getAll());
        }
        rsp.sendRedirect2(req.getContextPath());
    }

    void doResetScores(Collection<User> users) throws IOException {
        for (User user : users) {
            UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
            if (property == null) continue;
            property.setScore(0.0);
            user.save();
        }
    }

    public ACL getACL() {
        return Hudson.getInstance().getACL();
    }

    public void checkPermission(Permission p) {
        this.getACL().checkPermission(p);
    }

    public boolean hasPermission(Permission p) {
        return this.getACL().hasPermission(p);
    }
}

