/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.build;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.build.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultRule
implements Rule {
    private int failurePoints;
    private int successPoints;

    public BuildResultRule() {
        this(1, -10);
    }

    public BuildResultRule(int successPoints, int failurePoints) {
        this.successPoints = successPoints;
        this.failurePoints = failurePoints;
    }

    public String getName() {
        return Messages.BuildRuleSet_BuildResult();
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        Result lastResult = null;
        if (build.getPreviousBuild() != null) {
            lastResult = ((AbstractBuild)build.getPreviousBuild()).getResult();
        }
        return this.evaluate(result, lastResult);
    }

    RuleResult evaluate(Result result, Result lastResult) {
        if (result == Result.SUCCESS) {
            return new RuleResult((double)this.successPoints, Messages.BuildRuleSet_BuildSuccess());
        }
        if (result == Result.FAILURE && (lastResult == null || lastResult.isBetterThan(Result.FAILURE))) {
            return new RuleResult((double)this.failurePoints, Messages.BuildRuleSet_BuildFailed());
        }
        return null;
    }
}

