/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.pmd;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.pmd.Messages;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPmdRule
implements Rule {
    private int pointsForAddingAnAnnotation;
    private int pointsForRemovingAnAnnotation;
    private Priority tasksPriority;

    public DefaultPmdRule(Priority tasksPriority, int pointsForAddingAnAnnotation, int pointsForRemovingAnAnnotation) {
        this.tasksPriority = tasksPriority;
        this.pointsForAddingAnAnnotation = pointsForAddingAnAnnotation;
        this.pointsForRemovingAnAnnotation = pointsForRemovingAnAnnotation;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List sequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (sequence = new ActionSequenceRetriever(PmdResultAction.class, 2).getSequence(build)) != null && this.hasNoErrors((List)sequence.get(0)) && this.hasNoErrors((List)sequence.get(1))) {
            int delta = this.getNumberOfAnnotations((List)sequence.get(0)) - this.getNumberOfAnnotations((List)sequence.get(1));
            if (delta < 0) {
                return new RuleResult((double)(Math.abs(delta) * this.pointsForRemovingAnAnnotation), Messages.PmdRuleSet_DefaultRule_FixedWarningsCount((Object)Math.abs(delta), (Object)this.tasksPriority.name()));
            }
            if (delta > 0) {
                return new RuleResult((double)(Math.abs(delta) * this.pointsForAddingAnAnnotation), Messages.PmdRuleSet_DefaultRule_NewWarningsCount((Object)Math.abs(delta), (Object)this.tasksPriority.name()));
            }
        }
        return RuleResult.EMPTY_RESULT;
    }

    private boolean hasNoErrors(List<PmdResultAction> actions) {
        for (PmdResultAction action : actions) {
            if (!((PmdResult)action.getResult()).hasError()) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfAnnotations(List<PmdResultAction> actions) {
        int numberOfAnnotations = 0;
        for (PmdResultAction action : actions) {
            numberOfAnnotations += ((PmdResult)action.getResult()).getNumberOfAnnotations(this.tasksPriority);
        }
        return numberOfAnnotations;
    }

    public String getName() {
        return Messages.PmdRuleSet_DefaultRule_Name((Object)this.tasksPriority.name());
    }
}

