/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.opentasks;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.opentasks.Messages;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOpenTasksRule
implements Rule {
    private int pointsForAddingAnAnnotation;
    private int pointsForRemovingAnAnnotation;
    private Priority tasksPriority;

    public DefaultOpenTasksRule(Priority tasksPriority, int pointsForAddingAnAnnotation, int pointsForRemovingAnAnnotation) {
        this.tasksPriority = tasksPriority;
        this.pointsForAddingAnAnnotation = pointsForAddingAnAnnotation;
        this.pointsForRemovingAnAnnotation = pointsForRemovingAnAnnotation;
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List<List<TasksResultAction>> actionSequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (actionSequence = new ActionSequenceRetriever<TasksResultAction>(TasksResultAction.class, 2).getSequence(build)) != null && this.hasNoErrors(actionSequence.get(0)) && this.hasNoErrors(actionSequence.get(1))) {
            int numberOfAnnotations = this.getNumberOfAnnotations(actionSequence.get(0)) - this.getNumberOfAnnotations(actionSequence.get(1));
            if (numberOfAnnotations > 0) {
                return new RuleResult(numberOfAnnotations * this.pointsForAddingAnAnnotation, Messages.OpenTasksRule_DefaultRule_NewTasksCount(numberOfAnnotations, this.tasksPriority.name()));
            }
            if (numberOfAnnotations < 0) {
                return new RuleResult(numberOfAnnotations * -1 * this.pointsForRemovingAnAnnotation, Messages.OpenTasksRule_DefaultRule_FixedTasksCount(numberOfAnnotations * -1, this.tasksPriority.name()));
            }
        }
        return RuleResult.EMPTY_RESULT;
    }

    private boolean hasNoErrors(List<TasksResultAction> actions) {
        for (TasksResultAction action : actions) {
            if (!((TasksResult)action.getResult()).hasError()) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfAnnotations(List<TasksResultAction> actions) {
        int numberOfAnnotations = 0;
        for (TasksResultAction action : actions) {
            numberOfAnnotations += ((TasksResult)action.getResult()).getNumberOfAnnotations(this.tasksPriority);
        }
        return numberOfAnnotations;
    }

    @Override
    public String getName() {
        return Messages.OpenTasksRule_DefaultRule_Name(this.tasksPriority.name());
    }
}

