/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.unittesting.Messages;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncreasingFailedTestsRule
implements Rule {
    private double pointsForEachNewFailure;

    public IncreasingFailedTestsRule() {
        this(-1);
    }

    public IncreasingFailedTestsRule(int points) {
        this.pointsForEachNewFailure = points;
    }

    @Override
    public String getName() {
        return Messages.UnitTestingRuleSet_IncreasingFailedRule_Name();
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List actions = build.getActions(AbstractTestResultAction.class);
        for (AbstractTestResultAction action : actions) {
            if (action == null || action.getPreviousResult() == null) continue;
            return this.evaluate(build.getResult(), ((AbstractBuild)build.getPreviousBuild()).getResult(), action.getFailCount(), action.getPreviousResult().getFailCount());
        }
        return null;
    }

    RuleResult evaluate(Result currentResult, Result previousResult, int currentFailCount, int previousFailCount) {
        int failingTestDiff;
        if (previousResult.isBetterThan(Result.FAILURE) && currentResult.isBetterOrEqualTo(Result.UNSTABLE) && (failingTestDiff = currentFailCount - previousFailCount) > 0) {
            return new RuleResult((double)failingTestDiff * this.pointsForEachNewFailure, Messages.UnitTestingRuleSet_IncreasingFailedRule_Count(failingTestDiff));
        }
        return null;
    }
}

