/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.cigame.CaseInsensitiveUserIdComparator;
import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.Messages;
import hudson.plugins.cigame.ScoreCardAction;
import hudson.plugins.cigame.UserScoreProperty;
import hudson.plugins.cigame.model.ScoreCard;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class ScoreCardAction
implements Action {
    private static final long serialVersionUID = 1L;
    private AbstractBuild<?, ?> build;
    private ScoreCard scorecard;

    public ScoreCardAction(ScoreCard scorecard, AbstractBuild<?, ?> b) {
        this.build = b;
        this.scorecard = scorecard;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getDisplayName() {
        return Messages.Scorecard_Title();
    }

    public String getIconFileName() {
        return "/plugin/ci-game/icons/game-22x22.png";
    }

    public String getUrlName() {
        return "cigame";
    }

    @Exported
    public ScoreCard getScorecard() {
        return this.scorecard;
    }

    @Exported
    public Collection<User> getParticipants() {
        return this.getParticipants(((GameDescriptor)Hudson.getInstance().getDescriptorByType(GameDescriptor.class)).getNamesAreCaseSensitive());
    }

    Collection<User> getParticipants(boolean usernameIsCasesensitive) {
        CaseInsensitiveUserIdComparator userIdComparator = new CaseInsensitiveUserIdComparator();
        ArrayList<User> players = new ArrayList<User>();
        ChangeLogSet changeSet = this.build.getChangeSet();
        for (ChangeLogSet.Entry entry : changeSet) {
            User user = entry.getAuthor();
            UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
            if (property == null || !property.isParticipatingInGame() || !usernameIsCasesensitive && Collections.binarySearch(players, user, userIdComparator) >= 0) continue;
            players.add(user);
        }
        Collections.sort(players, new UserDisplayNameComparator(null));
        return players;
    }
}

