/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.cigame.GameDescriptor;
import hudson.plugins.cigame.ScoreCardAction;
import hudson.plugins.cigame.UserScoreProperty;
import hudson.plugins.cigame.model.RuleBook;
import hudson.plugins.cigame.model.ScoreCard;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamePublisher
extends Notifier {
    public GameDescriptor getDescriptor() {
        return (GameDescriptor)super.getDescriptor();
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.perform(build, this.getDescriptor().getRuleBook(), this.getDescriptor().getNamesAreCaseSensitive());
        return true;
    }

    boolean perform(AbstractBuild<?, ?> build, RuleBook ruleBook, boolean usernameIsCasesensitive) throws IOException {
        ScoreCard sc = new ScoreCard();
        sc.record(build, ruleBook);
        ScoreCardAction action = new ScoreCardAction(sc, build);
        build.getActions().add(action);
        return this.updateUserScores((ChangeLogSet<? extends ChangeLogSet.Entry>)build.getChangeSet(), sc.getTotalPoints(), usernameIsCasesensitive);
    }

    private boolean updateUserScores(ChangeLogSet<? extends ChangeLogSet.Entry> changeSet, double score, boolean usernameIsCasesensitive) throws IOException {
        TreeSet<User> players = new TreeSet<User>(usernameIsCasesensitive ? null : new UsernameCaseinsensitiveComparator());
        if (score != 0.0) {
            for (ChangeLogSet.Entry entry : changeSet) {
                players.add(entry.getAuthor());
            }
            for (User user : players) {
                UserScoreProperty property = (UserScoreProperty)user.getProperty(UserScoreProperty.class);
                if (property == null) {
                    property = new UserScoreProperty();
                    user.addProperty((UserProperty)property);
                }
                if (property.isParticipatingInGame()) {
                    property.setScore(property.getScore() + score);
                }
                user.save();
            }
        }
        return !players.isEmpty();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UsernameCaseinsensitiveComparator
    implements Comparator<User> {
        @Override
        public int compare(User arg0, User arg1) {
            return arg0.getId().compareToIgnoreCase(arg1.getId());
        }
    }
}

