/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame;

import hudson.model.User;
import hudson.model.UserProperty;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class UserScoreProperty
extends UserProperty {
    private double score;
    private boolean isNotParticipatingInGame;

    public UserScoreProperty() {
        this.score = 0.0;
        this.isNotParticipatingInGame = false;
    }

    @DataBoundConstructor
    public UserScoreProperty(double score, boolean participatingInGame) {
        this.score = score;
        this.isNotParticipatingInGame = !participatingInGame;
    }

    @Exported
    public User getUser() {
        return this.user;
    }

    @Exported
    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Exported
    public boolean isParticipatingInGame() {
        return !this.isNotParticipatingInGame;
    }

    public String toString() {
        return String.format("UserScoreProperty [isNotParticipatingInGame=%s, score=%s, user=%s]", this.isNotParticipatingInGame, this.score, this.user);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNotParticipatingInGame ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserScoreProperty)) {
            return false;
        }
        UserScoreProperty other = (UserScoreProperty)((Object)obj);
        if (this.isNotParticipatingInGame != other.isNotParticipatingInGame) {
            return false;
        }
        return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score);
    }
}

