/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.checkstyle;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.cigame.rules.plugins.checkstyle.Messages;
import hudson.plugins.cigame.util.ActionSequenceRetriever;
import hudson.plugins.cigame.util.ResultSequenceValidator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCheckstyleRule
implements Rule {
    private int pointsForAddingAWarning;
    private int pointsForRemovingAWarning;

    public DefaultCheckstyleRule(int pointsForAddingAWarning, int pointsForRemovingAWarning) {
        this.pointsForAddingAWarning = pointsForAddingAWarning;
        this.pointsForRemovingAWarning = pointsForRemovingAWarning;
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List<List<CheckStyleResultAction>> sequence;
        if (new ResultSequenceValidator(Result.UNSTABLE, 2).isValid(build) && (sequence = new ActionSequenceRetriever<CheckStyleResultAction>(CheckStyleResultAction.class, 2).getSequence(build)) != null && this.hasNoErrors(sequence.get(0)) && this.hasNoErrors(sequence.get(1))) {
            int numberOfWarnings = this.getNumberOfAnnotations(sequence.get(0)) - this.getNumberOfAnnotations(sequence.get(1));
            if (numberOfWarnings > 0) {
                return new RuleResult(numberOfWarnings * this.pointsForAddingAWarning, Messages.CheckstyleRuleSet_DefaultRule_NewWarningsCount(numberOfWarnings));
            }
            if (numberOfWarnings < 0) {
                return new RuleResult(numberOfWarnings * -1 * this.pointsForRemovingAWarning, Messages.CheckstyleRuleSet_DefaultRule_FixedWarningsCount(numberOfWarnings * -1));
            }
        }
        return RuleResult.EMPTY_RESULT;
    }

    private boolean hasNoErrors(List<CheckStyleResultAction> actions) {
        for (CheckStyleResultAction action : actions) {
            if (!((CheckStyleResult)action.getResult()).hasError()) continue;
            return false;
        }
        return true;
    }

    private int getNumberOfAnnotations(List<CheckStyleResultAction> actions) {
        int numberOfAnnotations = 0;
        for (CheckStyleResultAction action : actions) {
            numberOfAnnotations += ((CheckStyleResult)action.getResult()).getNumberOfAnnotations();
        }
        return numberOfAnnotations;
    }

    @Override
    public String getName() {
        return Messages.CheckstyleRuleSet_DefaultRule_Name();
    }
}

