/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFindBugsWarningsRule
implements Rule {
    private Priority priority;
    private int pointsForEachNewWarning;

    public NewFindBugsWarningsRule(Priority priority, int pointsForEachNewWarning) {
        this.priority = priority;
        this.pointsForEachNewWarning = pointsForEachNewWarning;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        int numberOfAnnotations = 0;
        if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) && build.getPreviousBuild() != null) {
            List actions = build.getActions(FindBugsResultAction.class);
            for (FindBugsResultAction action : actions) {
                if (action.getPreviousResultAction() == null) continue;
                numberOfAnnotations = ((FindBugsResult)action.getResult()).getNumberOfAnnotations(this.priority) - ((FindBugsResult)action.getPreviousResultAction().getResult()).getNumberOfAnnotations(this.priority);
            }
        }
        if (numberOfAnnotations > 0) {
            return new RuleResult((double)(numberOfAnnotations * this.pointsForEachNewWarning), String.format("%d new %s priority findbugs were found", Math.abs(numberOfAnnotations), this.priority.name()));
        }
        return null;
    }

    public String getName() {
        return String.format("New %s priority Findbugs warnings", this.priority.name());
    }
}

