/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.pmd;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPmdRule
implements Rule {
    private int pointsForAddingAnAnnotation;
    private int pointsForRemovingAnAnnotation;
    private Priority tasksPriority;

    public DefaultPmdRule(Priority tasksPriority, int pointsForAddingAnAnnotation, int pointsForRemovingAnAnnotation) {
        this.tasksPriority = tasksPriority;
        this.pointsForAddingAnAnnotation = pointsForAddingAnAnnotation;
        this.pointsForRemovingAnAnnotation = pointsForRemovingAnAnnotation;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        int delta = 0;
        if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) && build.getPreviousBuild() != null) {
            List actions = build.getActions(PmdResultAction.class);
            for (PmdResultAction action : actions) {
                PmdResultAction previousResultAction = action.getPreviousResultAction();
                if (previousResultAction == null) continue;
                PmdResult result = (PmdResult)action.getResult();
                PmdResult previousResult = (PmdResult)action.getPreviousResultAction().getResult();
                int annotations = result.getNumberOfAnnotations(this.tasksPriority);
                int previousAnnotations = previousResult.getNumberOfAnnotations(this.tasksPriority);
                delta += annotations - previousAnnotations;
            }
        }
        if (delta < 0) {
            return new RuleResult((double)(Math.abs(delta) * this.pointsForRemovingAnAnnotation), String.format("%d %s priority PMD warnings were fixed", Math.abs(delta), this.tasksPriority.name()));
        }
        if (delta > 0) {
            return new RuleResult((double)(Math.abs(delta) * this.pointsForAddingAnAnnotation), String.format("%d new %s priority PMD warnings were found", Math.abs(delta), this.tasksPriority.name()));
        }
        return null;
    }

    public String getName() {
        return String.format("%s priority PMD warnings", this.tasksPriority.name());
    }
}

