/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.warnings;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.warnings.WarningsResult;
import hudson.plugins.warnings.WarningsResultAction;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWarningsRule
implements Rule {
    private int pointsForAddingAWarning;
    private int pointsForRemovingAWarning;

    public DefaultWarningsRule(int pointsForAddingAWarning, int pointsForRemovingAWarning) {
        this.pointsForAddingAWarning = pointsForAddingAWarning;
        this.pointsForRemovingAWarning = pointsForRemovingAWarning;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        int numberOfAnnotations = 0;
        if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) || build.getPreviousBuild() != null) {
            List actions = build.getActions(WarningsResultAction.class);
            for (WarningsResultAction action : actions) {
                if (!action.hasPreviousResultAction()) continue;
                WarningsResult result = (WarningsResult)action.getResult();
                WarningsResult previousResult = (WarningsResult)action.getPreviousResultAction().getResult();
                Collection annotations = result.getAnnotations();
                Collection previousAnnotations = previousResult.getAnnotations();
                if (annotations == null || previousAnnotations == null) continue;
                numberOfAnnotations += annotations.size() - previousAnnotations.size();
            }
        }
        if (numberOfAnnotations > 0) {
            return new RuleResult((double)(numberOfAnnotations * this.pointsForAddingAWarning), String.format("%d new compiler warnings were found", numberOfAnnotations));
        }
        if (numberOfAnnotations < 0) {
            return new RuleResult((double)(numberOfAnnotations * -1 * this.pointsForRemovingAWarning), String.format("%d compiler warnings were fixed", numberOfAnnotations * -1));
        }
        return null;
    }

    public String getName() {
        return "Changed number of compiler warnings";
    }
}

