/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.util.model.Priority;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedFindBugsWarningsRule
implements Rule {
    private Priority priority;
    private int pointsForEachFixedWarning;

    public FixedFindBugsWarningsRule(Priority priority, int pointsForEachFixedWarning) {
        this.priority = priority;
        this.pointsForEachFixedWarning = pointsForEachFixedWarning;
    }

    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        int numberOfAnnotations = 0;
        if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) && build.getPreviousBuild() != null) {
            List actions = build.getActions(FindBugsResultAction.class);
            for (FindBugsResultAction action : actions) {
                if (!action.hasPreviousResultAction()) continue;
                numberOfAnnotations = ((FindBugsResult)action.getPreviousResultAction().getResult()).getNumberOfAnnotations(this.priority) - ((FindBugsResult)action.getResult()).getNumberOfAnnotations(this.priority);
            }
        }
        if (numberOfAnnotations > 0) {
            return new RuleResult((double)(numberOfAnnotations * this.pointsForEachFixedWarning), String.format("%d %s priority findbugs warnings were fixed", Math.abs(numberOfAnnotations), this.priority.name()));
        }
        return new RuleResult(0.0, String.format("No fixed %s priority findbugs warnings found.", this.priority.name()));
    }

    public String getName() {
        return String.format("Fixed %s priority Findbugs warnings", this.priority.name());
    }
}

