/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cigame.rules.unittesting;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.cigame.model.Rule;
import hudson.plugins.cigame.model.RuleResult;
import hudson.tasks.junit.TestResultAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncreasingFailedTestsRule
implements Rule {
    private double pointsForEachNewFailure;

    public IncreasingFailedTestsRule() {
        this(-1);
    }

    public IncreasingFailedTestsRule(int points) {
        this.pointsForEachNewFailure = points;
    }

    @Override
    public String getName() {
        return "Increased number of failed tests";
    }

    @Override
    public RuleResult evaluate(AbstractBuild<?, ?> build) {
        List actions = build.getActions(TestResultAction.class);
        for (TestResultAction action : actions) {
            if (action == null || action.getPreviousResult() == null) continue;
            return this.evaluate(build.getResult(), ((AbstractBuild)build.getPreviousBuild()).getResult(), action.getResult().getFailCount(), ((TestResultAction)action.getPreviousResult()).getResult().getFailCount());
        }
        return null;
    }

    RuleResult evaluate(Result currentResult, Result previousResult, int currentFailCount, int previousFailCount) {
        int failingTestDiff;
        if (previousResult.isBetterThan(Result.FAILURE) && currentResult.isBetterOrEqualTo(Result.UNSTABLE) && (failingTestDiff = currentFailCount - previousFailCount) > 0) {
            return new RuleResult((double)failingTestDiff * this.pointsForEachNewFailure, String.format("%d new failing tests were added", failingTestDiff));
        }
        return null;
    }
}

