/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.clearcaserelease;

import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseCancelAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseCompositeBaselineAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseLatestBaselineAction;
import hudson.cli.declarative.CLIMethod;
import hudson.cli.declarative.CLIResolver;
import hudson.model.AbstractItem;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;

public class ClearcaseReleaseCLI {
    private AbstractItem job;
    private int buildnumber;

    public ClearcaseReleaseCLI(AbstractItem job, int buildnumber) {
        this.job = job;
        this.buildnumber = buildnumber;
    }

    @CLIResolver
    public static ClearcaseReleaseCLI resolveForCLI(@Argument(required=true, metaVar="NAME", usage="Job name") String name, @Argument(index=1, required=false, metaVar="BUILD#", usage="Build number") String id) throws CmdLineException {
        AbstractItem item = (AbstractItem)Hudson.getInstance().getItemByFullName(name, AbstractItem.class);
        if (item == null) {
            throw new CmdLineException(null, "A job parameter is required");
        }
        int buildnumber = 0;
        if (id != null) {
            try {
                buildnumber = Integer.parseInt(id);
            }
            catch (NumberFormatException nfe) {
                throw new CmdLineException(null, "A job build number (number) is required :" + id);
            }
        }
        return new ClearcaseReleaseCLI(item, buildnumber);
    }

    @CLIMethod(name="clearcaseCancelRelease")
    public synchronized void clearcaseCancelRelease() throws IOException, InterruptedException {
        Run run = ((Job)this.job).getBuildByNumber(this.buildnumber);
        ClearcaseReleaseCancelAction clearcaseReleaseCancelAction = (ClearcaseReleaseCancelAction)run.getAction(ClearcaseReleaseCancelAction.class);
        clearcaseReleaseCancelAction.process();
    }

    @CLIMethod(name="clearcasePromoteCompositeBaseline")
    public synchronized void clearcasePromoteCompositeBaseline() throws IOException, InterruptedException {
        Run run = ((Job)this.job).getBuildByNumber(this.buildnumber);
        ClearcaseReleaseCompositeBaselineAction clearcaseReleaseCompositeBaselineAction = (ClearcaseReleaseCompositeBaselineAction)run.getAction(ClearcaseReleaseCompositeBaselineAction.class);
        clearcaseReleaseCompositeBaselineAction.process();
    }

    @CLIMethod(name="clearcasePromoteLatestBaselines")
    public synchronized void clearcasePromoteLatestBaselines() throws IOException, InterruptedException {
        ClearcaseReleaseLatestBaselineAction clearcaseReleaseLatestBaselineAction = (ClearcaseReleaseLatestBaselineAction)this.job.getAction(ClearcaseReleaseLatestBaselineAction.class);
        clearcaseReleaseLatestBaselineAction.process();
    }
}

