/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.clearcaserelease;

import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseLatestBaselineAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.Messages;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskThread;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearcaseReleaseLatestBaselineAction
extends ClearcaseReleaseAction {
    private final AbstractProject project;
    private final String customReleasePromotionLevel;

    public ClearcaseReleaseLatestBaselineAction(AbstractProject project, String customReleasePromotionLevel) {
        super(project.getWorkspace());
        this.project = project;
        this.customReleasePromotionLevel = customReleasePromotionLevel;
    }

    public Run getOwner() {
        return this.project.getLastSuccessfulBuild();
    }

    public String getUrlName() {
        return "clearcasereleaselatestbaseline";
    }

    public String getIconFileName() {
        Run lastBuild = this.project.getLastSuccessfulBuild();
        if (lastBuild != null && this.hasReleasePermission(this.project)) {
            return "installer.gif";
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.ReleaseAction_perform_latestBaselines_name();
    }

    protected ACL getACL() {
        return this.getOwner().getACL();
    }

    private List<String> getModComponentsFromStream(String streamPVOB, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("\"%[mod_comps]p\"");
        cmd.add(streamPVOB);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String reusltClt = baos.toString();
        return Arrays.asList(reusltClt.split(" "));
    }

    private List<String> getLatestBaselines(String streanWithPVOB, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("\"%[latest_bls]CXp\"");
        cmd.add(streanWithPVOB);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String resultClt = baos.toString();
        resultClt = resultClt.replace("baseline:", "");
        return Arrays.asList(resultClt.split(", "));
    }

    private String getComponentFromBaseline(String baseLineWithPVOB, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("\"%[component]p\"");
        cmd.add(baseLineWithPVOB);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String componentName = baos.toString();
        return componentName;
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException, InterruptedException {
        this.getACL().checkPermission(SCM.TAG);
        this.process();
        this.doIndex(req, resp);
    }

    public void process() {
        SCM scm = this.project.getScm();
        if (scm instanceof ClearCaseUcmSCM) {
            ClearCaseUcmSCM clearCaseUcmSCM = (ClearCaseUcmSCM)scm;
            new TagWorkerThread(this, clearCaseUcmSCM).start();
        }
    }

    static /* synthetic */ List access$000(ClearcaseReleaseLatestBaselineAction x0, String x1, HudsonClearToolLauncher x2, FilePath x3) throws IOException, InterruptedException {
        return x0.getLatestBaselines(x1, x2, x3);
    }

    static /* synthetic */ List access$100(ClearcaseReleaseLatestBaselineAction x0, String x1, HudsonClearToolLauncher x2, FilePath x3) throws IOException, InterruptedException {
        return x0.getModComponentsFromStream(x1, x2, x3);
    }

    static /* synthetic */ String access$200(ClearcaseReleaseLatestBaselineAction x0, String x1, HudsonClearToolLauncher x2, FilePath x3) throws IOException, InterruptedException {
        return x0.getComponentFromBaseline(x1, x2, x3);
    }

    static /* synthetic */ TaskThread access$302(ClearcaseReleaseLatestBaselineAction x0, TaskThread x1) {
        x0.workerThread = x1;
        return x0.workerThread;
    }

    static /* synthetic */ String access$400(ClearcaseReleaseLatestBaselineAction x0) {
        return x0.customReleasePromotionLevel;
    }

    static /* synthetic */ AbstractProject access$500(ClearcaseReleaseLatestBaselineAction x0) {
        return x0.project;
    }

    static /* synthetic */ TaskThread access$602(ClearcaseReleaseLatestBaselineAction x0, TaskThread x1) {
        x0.workerThread = x1;
        return x0.workerThread;
    }
}

