/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.clearcaserelease;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.scm.SCM;
import hudson.security.Permission;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class ClearcaseReleaseAction
extends TaskAction {
    protected final FilePath workspaceRoot;

    protected Permission getPermission() {
        return SCM.TAG;
    }

    protected ClearcaseReleaseAction(FilePath workapace) {
        this.workspaceRoot = workapace;
    }

    protected HudsonClearToolLauncher getHudsonClearToolLauncher(TaskListener listener, Launcher launcher) {
        HudsonClearToolLauncher clearToolLauncher = new HudsonClearToolLauncher(PluginImpl.BASE_DESCRIPTOR.getCleartoolExe(), "clearcase-release", listener, this.workspaceRoot, launcher);
        return clearToolLauncher;
    }

    protected boolean hasReleasePermission(AbstractProject job) {
        return job.hasPermission(this.getPermission());
    }

    protected void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        req.getView((Object)this, this.chooseAction()).forward((ServletRequest)req, (ServletResponse)rsp);
    }

    protected synchronized String chooseAction() {
        if (this.workerThread != null) {
            return "inProgress.jelly";
        }
        return "index.jelly";
    }

    protected String getStatusBaseLine(String baseLine, String pvob, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("\"%[plevel]p\"");
        cmd.add(baseLine + "@" + File.separator + pvob);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String componentName = baos.toString();
        return componentName;
    }

    protected void changeLevelBaseline(String baselineNameWithPVOB, String status, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws InterruptedException, IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("chbl");
        cmd.add("-level");
        cmd.add(status);
        cmd.add(baselineNameWithPVOB);
        clearToolLauncher.run(cmd.toCommandArray(), null, null, filePath);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum BASELINE_PROMOTION_LEVEL {
        RELEASED("RELEASED"),
        BUILT("BUILT");

        private String level;

        private BASELINE_PROMOTION_LEVEL(String level) {
            this.level = level;
        }

        public String getLevel() {
            return this.level;
        }
    }
}

