/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.clearcaserelease;

import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseBuildBadgeAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseCancelAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.Messages;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.ucm.UcmMakeBaselineComposite;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ClearcaseReleaseCompositeBaselineAction
extends ClearcaseReleaseAction {
    private final AbstractBuild owner;
    private final String customReleasePromotionLevel;

    public ClearcaseReleaseCompositeBaselineAction(AbstractBuild owner, String customReleasePromotionLevel) {
        super(owner.getWorkspace());
        this.owner = owner;
        this.customReleasePromotionLevel = customReleasePromotionLevel;
    }

    public AbstractBuild getOwner() {
        return this.owner;
    }

    public String getDisplayName() {
        return Messages.ReleaseAction_perform_buildCompositeBaseline_name();
    }

    protected ACL getACL() {
        return this.owner.getACL();
    }

    public String getIconFileName() {
        if (this.hasReleasePermission(this.owner.getProject())) {
            return "installer.gif";
        }
        return null;
    }

    public String getUrlName() {
        return "clearcasereleasecompositebaseline";
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException, InterruptedException {
        this.getACL().checkPermission(SCM.TAG);
        this.process();
        this.doIndex(req, resp);
    }

    public void process() {
        SCM scm = this.owner.getProject().getScm();
        if (scm instanceof ClearCaseUcmSCM) {
            new TagWorkerThread().start();
        }
    }

    public final class TagWorkerThread
    extends TaskThread {
        public TagWorkerThread() {
            super((TaskAction)ClearcaseReleaseCompositeBaselineAction.this, TaskThread.ListenerAndText.forMemory());
        }

        protected void perform(TaskListener listener) {
            try {
                listener.getLogger().println("\nClearcase release preforming");
                Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
                HudsonClearToolLauncher clearToolLauncher = ClearcaseReleaseCompositeBaselineAction.this.getHudsonClearToolLauncher(listener, (Launcher)launcher);
                UcmMakeBaselineComposite composite = (UcmMakeBaselineComposite)ClearcaseReleaseCompositeBaselineAction.this.owner.getProject().getPublishersList().get(UcmMakeBaselineComposite.class);
                if (composite == null) {
                    listener.getLogger().println("[ERROR] - No composite baseline has been configured for the job.");
                } else {
                    String compositeStreamSelector;
                    String compositeBaseLine = composite.getCompositeNamePattern();
                    compositeBaseLine = Util.replaceMacro((String)compositeBaseLine, (Map)ClearcaseReleaseCompositeBaselineAction.this.owner.getEnvironment(listener));
                    String pvob = compositeStreamSelector = composite.getCompositeStreamSelector();
                    if (compositeStreamSelector.contains("@" + File.separator)) {
                        pvob = compositeStreamSelector.substring(compositeStreamSelector.indexOf("@" + File.separator) + 2, compositeStreamSelector.length());
                    }
                    listener.getLogger().println("Check the status of the composite baseline '" + compositeBaseLine + "'");
                    String compositeBaselineStatus = ClearcaseReleaseCompositeBaselineAction.this.getStatusBaseLine(compositeBaseLine, pvob, clearToolLauncher, ClearcaseReleaseCompositeBaselineAction.this.workspaceRoot);
                    if ("BUILT".equals(compositeBaselineStatus)) {
                        String status = ClearcaseReleaseCompositeBaselineAction.this.customReleasePromotionLevel == null ? ClearcaseReleaseAction.BASELINE_PROMOTION_LEVEL.RELEASED.getLevel() : ClearcaseReleaseCompositeBaselineAction.this.customReleasePromotionLevel;
                        listener.getLogger().println("Promote to the release promotion level the composite baseline '" + compositeBaseLine + "' with the level '" + status + '\"');
                        ClearcaseReleaseCompositeBaselineAction.this.changeLevelBaseline(compositeBaseLine + "@\\" + pvob, status, clearToolLauncher, ClearcaseReleaseCompositeBaselineAction.this.workspaceRoot);
                        listener.getLogger().println("");
                        String compositeBaseNameDescription = compositeBaseLine + ":RELEASED";
                        ClearcaseReleaseBuildBadgeAction releaseBuildBadgeAction = new ClearcaseReleaseBuildBadgeAction(compositeBaseNameDescription);
                        ClearcaseReleaseCompositeBaselineAction.this.owner.addAction((Action)releaseBuildBadgeAction);
                        ClearcaseReleaseCompositeBaselineAction.this.owner.addAction((Action)new ClearcaseReleaseCancelAction((Run)ClearcaseReleaseCompositeBaselineAction.this.owner, ClearcaseReleaseCompositeBaselineAction.this.owner.getProject(), ClearcaseReleaseCompositeBaselineAction.this.workspaceRoot, releaseBuildBadgeAction, Arrays.asList(compositeBaseLine + "@\\" + pvob)));
                        ClearcaseReleaseCompositeBaselineAction.this.owner.keepLog();
                        ClearcaseReleaseCompositeBaselineAction.this.owner.save();
                    } else {
                        listener.getLogger().println("\nThe composite baseline '" + compositeBaseLine + "' hasn't the status BUILT.");
                    }
                }
            }
            catch (Throwable e) {
                listener.getLogger().println("[ERROR] - " + e.getMessage());
            }
            ClearcaseReleaseCompositeBaselineAction.this.workerThread = null;
            listener.getLogger().println("");
        }
    }
}

