/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.clearcaserelease;

import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseBuildBadgeAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.ClearcaseReleaseCancelAction;
import com.thalesgroup.hudson.plugins.clearcaserelease.Messages;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.plugins.clearcase.ClearCaseUcmSCM;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearcaseReleaseLatestBaselineAction
extends ClearcaseReleaseAction {
    private final AbstractProject project;
    private final String customReleasePromotionLevel;

    public ClearcaseReleaseLatestBaselineAction(AbstractProject project, String customReleasePromotionLevel) {
        super(project.getWorkspace());
        this.project = project;
        this.customReleasePromotionLevel = customReleasePromotionLevel;
    }

    public Run getOwner() {
        return this.project.getLastSuccessfulBuild();
    }

    public String getUrlName() {
        return "clearcasereleaselatestbaseline";
    }

    public String getIconFileName() {
        Run lastBuild = this.project.getLastSuccessfulBuild();
        if (lastBuild != null && this.hasReleasePermission(this.project)) {
            return "installer.gif";
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.ReleaseAction_perform_latestBaselines_name();
    }

    protected ACL getACL() {
        return this.getOwner().getACL();
    }

    private List<String> getModComponentsFromStream(String streamPVOB, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("\"%[mod_comps]p\"");
        cmd.add(streamPVOB);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String reusltClt = baos.toString();
        return Arrays.asList(reusltClt.split(" "));
    }

    private List<String> getLatestBaselines(String streanWithPVOB, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsstream");
        cmd.add("-fmt");
        cmd.add("\"%[latest_bls]CXp\"");
        cmd.add(streanWithPVOB);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String resultClt = baos.toString();
        resultClt = resultClt.replace("baseline:", "");
        return Arrays.asList(resultClt.split(", "));
    }

    private String getComponentFromBaseline(String baseLineWithPVOB, HudsonClearToolLauncher clearToolLauncher, FilePath filePath) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("\"%[component]p\"");
        cmd.add(baseLineWithPVOB);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        clearToolLauncher.run(cmd.toCommandArray(), null, (OutputStream)baos, filePath);
        baos.close();
        String componentName = baos.toString();
        return componentName;
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException, InterruptedException {
        this.getACL().checkPermission(SCM.TAG);
        this.process();
        this.doIndex(req, resp);
    }

    public void process() {
        SCM scm = this.project.getScm();
        if (scm instanceof ClearCaseUcmSCM) {
            ClearCaseUcmSCM clearCaseUcmSCM = (ClearCaseUcmSCM)scm;
            new TagWorkerThread(clearCaseUcmSCM).start();
        }
    }

    public final class TagWorkerThread
    extends TaskThread {
        private final ClearCaseUcmSCM clearCaseUcmSCM;

        public TagWorkerThread(ClearCaseUcmSCM clearCaseUcmSCM) {
            super((TaskAction)ClearcaseReleaseLatestBaselineAction.this, TaskThread.ListenerAndText.forMemory());
            this.clearCaseUcmSCM = clearCaseUcmSCM;
        }

        protected void perform(TaskListener listener) {
            try {
                String streamWithPVOB;
                Run owner = ClearcaseReleaseLatestBaselineAction.this.getOwner();
                listener.getLogger().println("Performing the release of the latest baselines");
                String pvob = streamWithPVOB = this.clearCaseUcmSCM.getStream();
                if (pvob.contains("@" + File.separator)) {
                    pvob = pvob.substring(pvob.indexOf("@" + File.separator) + 2, pvob.length());
                }
                Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
                HudsonClearToolLauncher clearToolLauncher = ClearcaseReleaseLatestBaselineAction.this.getHudsonClearToolLauncher(listener, (Launcher)launcher);
                List latestBaselines = ClearcaseReleaseLatestBaselineAction.this.getLatestBaselines(streamWithPVOB, clearToolLauncher, ClearcaseReleaseLatestBaselineAction.this.workspaceRoot);
                listener.getLogger().println("");
                List modComps = ClearcaseReleaseLatestBaselineAction.this.getModComponentsFromStream(streamWithPVOB, clearToolLauncher, ClearcaseReleaseLatestBaselineAction.this.workspaceRoot);
                listener.getLogger().println("");
                ArrayList<String> keepBaselines = new ArrayList<String>();
                for (String latestBaseline : latestBaselines) {
                    String comp = ClearcaseReleaseLatestBaselineAction.this.getComponentFromBaseline(latestBaseline, clearToolLauncher, ClearcaseReleaseLatestBaselineAction.this.workspaceRoot);
                    listener.getLogger().println("");
                    if (!modComps.contains(comp)) continue;
                    keepBaselines.add(latestBaseline);
                }
                if (keepBaselines.size() == 0) {
                    listener.getLogger().println("There is not baseline to promote to RELEASE");
                    ClearcaseReleaseLatestBaselineAction.this.workerThread = null;
                    return;
                }
                StringBuffer latestBls = new StringBuffer();
                for (String latestBaselineWithPVOB : keepBaselines) {
                    String status = ClearcaseReleaseLatestBaselineAction.this.customReleasePromotionLevel == null ? ClearcaseReleaseAction.BASELINE_PROMOTION_LEVEL.RELEASED.getLevel() : ClearcaseReleaseLatestBaselineAction.this.customReleasePromotionLevel;
                    ClearcaseReleaseLatestBaselineAction.this.changeLevelBaseline(latestBaselineWithPVOB, status, clearToolLauncher, ClearcaseReleaseLatestBaselineAction.this.workspaceRoot);
                    listener.getLogger().println("");
                    latestBls.append(";");
                    latestBls.append(latestBaselineWithPVOB);
                }
                if (latestBls.length() != 0) {
                    latestBls.delete(0, 1);
                }
                String latestBaselinesReleaseDescription = "The latest baseline has been released";
                ClearcaseReleaseBuildBadgeAction releaseBuildBadgeAction = new ClearcaseReleaseBuildBadgeAction(latestBaselinesReleaseDescription);
                owner.addAction((Action)releaseBuildBadgeAction);
                ArrayList<StringParameterValue> parameters = new ArrayList<StringParameterValue>();
                parameters.add(new StringParameterValue("LATEST_BASELINE", latestBls.toString()));
                owner.addAction((Action)new ParametersAction(parameters));
                owner.addAction((Action)new ClearcaseReleaseCancelAction(owner, ClearcaseReleaseLatestBaselineAction.this.project, ClearcaseReleaseLatestBaselineAction.this.workspaceRoot, releaseBuildBadgeAction, keepBaselines));
                owner.keepLog();
                owner.save();
            }
            catch (Throwable e) {
                listener.getLogger().println("[ERROR] - " + e.getMessage());
            }
            ClearcaseReleaseLatestBaselineAction.this.workerThread = null;
        }
    }
}

