/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineParameterValue;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineUtils;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.PluginImpl;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.json.JSONObject;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ClearCaseUcmBaselineParameterDefinition
extends ParameterDefinition {
    public static final String PARAMETER_NAME = "ClearCase UCM baseline";
    private final String component;
    private final String pvob;
    private final String viewName;
    private final String vob;
    private final String promotionLevel;

    @DataBoundConstructor
    public ClearCaseUcmBaselineParameterDefinition(String pvob, String vob, String component, String promotionLevel, String viewName) {
        super(PARAMETER_NAME);
        this.pvob = pvob;
        this.vob = vob;
        this.component = component;
        this.promotionLevel = promotionLevel;
        this.viewName = viewName;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new ClearCaseUcmBaselineParameterValue(this.getName(), this.getPvob(), this.getVob(), this.getComponent(), this.getPromotionLevel(), this.getViewName(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        ClearCaseUcmBaselineParameterValue value = (ClearCaseUcmBaselineParameterValue)((Object)req.bindJSON(ClearCaseUcmBaselineParameterValue.class, formData));
        value.setPvob(this.pvob);
        value.setVob(this.vob);
        value.setComponent(this.component);
        value.setPromotionLevel(this.promotionLevel);
        value.setViewName(this.viewName);
        return value;
    }

    public String[] getBaselines() throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(PluginImpl.getDescriptor().getCleartoolExe());
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[name]p ");
        if (this.promotionLevel != null && this.promotionLevel.length() > 0) {
            cmd.add("-level");
            cmd.add(this.promotionLevel);
        }
        cmd.add("-component");
        cmd.add(this.component + '@' + this.pvob);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Hudson.getInstance().createLauncher(TaskListener.NULL).launch().cmds(cmd).stdout((OutputStream)baos).join();
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        if (cleartoolOutput.toString().contains("cleartool: Error")) {
            return null;
        }
        return cleartoolOutput.toString().split(" ");
    }

    public String getComponent() {
        return this.component;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public String getPvob() {
        return this.pvob;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getVob() {
        return this.vob;
    }

    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public FormValidation doCheckComponent(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("ComponentMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPromotionLevel(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("PromotionLevelShouldBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPvob(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("PVOBMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckViewName(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("ViewNameMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVob(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("VOBMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("DisplayName", new Object[0]);
        }
    }
}

