/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineParameterDefinition;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineSCM;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearToolUcmBaseline;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.ParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.HudsonClearToolLauncher;
import hudson.plugins.clearcase.PluginImpl;
import hudson.plugins.clearcase.util.BuildVariableResolver;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmBaselineParameterValue
extends ParameterValue {
    @Exported(visibility=3)
    private String baseline;
    @Exported(visibility=3)
    private String component;
    @Exported(visibility=3)
    private String promotionLevel;
    @Exported(visibility=3)
    private String pvob;
    private List<String> restrictions;
    @Exported(visibility=3)
    private String viewName;
    @Exported(visibility=3)
    private String vob;
    private String normalizedViewName;

    @DataBoundConstructor
    public ClearCaseUcmBaselineParameterValue(String name, String pvob, String vob, String component, String promotionLevel, String viewName, String baseline) {
        super(name);
        this.pvob = pvob;
        this.vob = vob;
        this.component = component;
        this.promotionLevel = promotionLevel;
        this.viewName = viewName;
        this.baseline = baseline;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (this.baseline == null || this.baseline.length() == 0) {
            return new BuildWrapper(){

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    listener.fatalError("The value '" + ClearCaseUcmBaselineParameterValue.this.baseline + "' is not a valid ClearCase UCM baseline.");
                    return null;
                }
            };
        }
        if (build.getProject().getScm() instanceof ClearCaseUcmBaselineSCM) {
            return new BuildWrapper(){

                private ClearToolLauncher createClearToolLauncher(TaskListener listener, FilePath workspace, Launcher launcher) {
                    return new HudsonClearToolLauncher(PluginImpl.getDescriptor().getCleartoolExe(), Hudson.getInstance().getDescriptor(ClearCaseUcmBaselineSCM.class).getDisplayName(), listener, workspace, launcher);
                }

                private String generateNormalizedViewName(VariableResolver variableResolver, String viewName) {
                    String normalizedViewName = Util.replaceMacro((String)viewName, (VariableResolver)variableResolver);
                    normalizedViewName = normalizedViewName.replaceAll("[\\s\\\\\\/:\\?\\*\\|]+", "_");
                    return normalizedViewName;
                }

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    String component;
                    String dependentBaseline;
                    String[] dependentBaselines;
                    BuildVariableResolver variableResolver = new BuildVariableResolver(build, launcher);
                    ClearToolLauncher clearToolLauncher = this.createClearToolLauncher((TaskListener)listener, build.getProject().getWorkspace(), launcher);
                    ClearToolUcmBaseline cleartool = new ClearToolUcmBaseline((VariableResolver)variableResolver, clearToolLauncher);
                    ClearCaseUcmBaselineParameterValue.this.normalizedViewName = this.generateNormalizedViewName((VariableResolver)variableResolver, ClearCaseUcmBaselineParameterValue.this.viewName);
                    FilePath workspace = build.getProject().getWorkspace();
                    FilePath viewPath = workspace.child(ClearCaseUcmBaselineParameterValue.this.normalizedViewName);
                    String rootDir = '/' + ClearCaseUcmBaselineParameterValue.this.vob + '/' + ClearCaseUcmBaselineParameterValue.this.component;
                    StringBuilder configSpec = new StringBuilder();
                    if (viewPath.exists()) {
                        cleartool.rmview(ClearCaseUcmBaselineParameterValue.this.normalizedViewName);
                    }
                    cleartool.mkview(ClearCaseUcmBaselineParameterValue.this.normalizedViewName, null);
                    configSpec.append("element * CHECKEDOUT\n");
                    configSpec.append("element ").append(rootDir).append("/... ").append(ClearCaseUcmBaselineParameterValue.this.baseline).append('\n');
                    for (String dependentBaselineSelector : dependentBaselines = cleartool.getDependentBaselines(ClearCaseUcmBaselineParameterValue.this.pvob, ClearCaseUcmBaselineParameterValue.this.baseline)) {
                        dependentBaseline = dependentBaselineSelector.split("@")[0];
                        component = cleartool.getComponentFromBaseline(ClearCaseUcmBaselineParameterValue.this.pvob, dependentBaseline);
                        rootDir = cleartool.getComponentRootDir(ClearCaseUcmBaselineParameterValue.this.pvob, component);
                        configSpec.append("element ").append(rootDir).append("/... ").append(dependentBaseline).append('\n');
                    }
                    configSpec.append("element * /main/0\n");
                    if (ClearCaseUcmBaselineParameterValue.this.restrictions != null && ClearCaseUcmBaselineParameterValue.this.restrictions.size() > 0) {
                        for (String restriction : ClearCaseUcmBaselineParameterValue.this.restrictions) {
                            if (!restriction.startsWith(rootDir)) continue;
                            configSpec.append("load ").append(restriction).append('\n');
                        }
                    } else {
                        configSpec.append("load ").append(rootDir).append('\n');
                    }
                    for (String dependentBaselineSelector : dependentBaselines) {
                        dependentBaseline = dependentBaselineSelector.split("@")[0];
                        component = cleartool.getComponentFromBaseline(ClearCaseUcmBaselineParameterValue.this.pvob, dependentBaseline);
                        rootDir = cleartool.getComponentRootDir(ClearCaseUcmBaselineParameterValue.this.pvob, component);
                        if (ClearCaseUcmBaselineParameterValue.this.restrictions != null && ClearCaseUcmBaselineParameterValue.this.restrictions.size() > 0) {
                            for (String restriction : ClearCaseUcmBaselineParameterValue.this.restrictions) {
                                if (!restriction.startsWith(rootDir)) continue;
                                configSpec.append("load ").append(restriction).append('\n');
                            }
                            continue;
                        }
                        configSpec.append("load ").append(rootDir).append('\n');
                    }
                    listener.getLogger().println("The view will be created based on the following config spec:");
                    listener.getLogger().println("--- config spec start ---");
                    listener.getLogger().print(configSpec.toString());
                    listener.getLogger().println("---  config spec end  ---");
                    cleartool.setcs(ClearCaseUcmBaselineParameterValue.this.normalizedViewName, configSpec.toString());
                    return new BuildWrapper.Environment(){

                        public void buildEnvVars(Map<String, String> env) {
                            env.put("CLEARCASE_VIEWNAME", ClearCaseUcmBaselineParameterValue.this.normalizedViewName);
                            env.put("CLEARCASE_VIEWPATH", env.get("WORKSPACE") + File.separator + ClearCaseUcmBaselineParameterValue.this.normalizedViewName);
                        }
                    };
                }
            };
        }
        return new BuildWrapper(){

            public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                String ccUcmBaselineSCMDisplayName = Hudson.getInstance().getDescriptor(ClearCaseUcmBaselineSCM.class).getDisplayName();
                listener.fatalError("This job is not set up to use a '" + ccUcmBaselineSCMDisplayName + "' SCM while it has a '" + Hudson.getInstance().getDescriptor(ClearCaseUcmBaselineParameterDefinition.class).getDisplayName() + "' parameter: Either remove the parameter or set the SCM to be '" + ccUcmBaselineSCMDisplayName + "'; In the meantime: Aborting!");
                return null;
            }
        };
    }

    public String getBaseline() {
        return this.baseline;
    }

    public void setBaseline(String baseline) {
        this.baseline = baseline;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public void setPromotionLevel(String promotionLevel) {
        this.promotionLevel = promotionLevel;
    }

    public String getPvob() {
        return this.pvob;
    }

    public void setPvob(String pvob) {
        this.pvob = pvob;
    }

    public void setRestrictions(List<String> restrictions) {
        this.restrictions = restrictions;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getVob() {
        return this.vob;
    }

    public void setVob(String vob) {
        this.vob = vob;
    }
}

