/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineParameterValue;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineUtils;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.plugins.clearcase.PluginImpl;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmBaselineParameterDefinition
extends ParameterDefinition
implements Comparable<ClearCaseUcmBaselineParameterDefinition> {
    public static final String PARAMETER_NAME = "ClearCase UCM baseline";
    private final String component;
    private final boolean forceRmview;
    private final String promotionLevel;
    private final String pvob;
    private final String restrictions;
    private final boolean snapshotView;
    private final String viewName;
    private final UUID uuid;

    @DataBoundConstructor
    public ClearCaseUcmBaselineParameterDefinition(String pvob, String component, String promotionLevel, String restrictions, String viewName, boolean snapshotView, boolean forceRmview, String uuid) {
        super(PARAMETER_NAME);
        this.pvob = ClearCaseUcmBaselineUtils.prefixWithSlash(pvob);
        this.component = component;
        this.promotionLevel = promotionLevel;
        this.restrictions = restrictions;
        this.viewName = viewName;
        this.snapshotView = snapshotView;
        this.forceRmview = forceRmview;
        this.uuid = uuid == null || uuid.length() == 0 ? UUID.randomUUID() : UUID.fromString(uuid);
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new ClearCaseUcmBaselineParameterValue(this.getName(), this.getPvob(), this.getComponent(), this.getPromotionLevel(), this.getViewName(), values[0], this.getForceRmview(), this.getSnapshotView());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        ClearCaseUcmBaselineParameterValue value = (ClearCaseUcmBaselineParameterValue)((Object)req.bindJSON(ClearCaseUcmBaselineParameterValue.class, formData));
        value.setPvob(this.pvob);
        value.setComponent(this.component);
        value.setPromotionLevel(this.promotionLevel);
        value.setRestrictions(this.getRestrictionsAsList());
        value.setViewName(this.viewName);
        value.setSnapshotView(this.snapshotView);
        return value;
    }

    public String[] getBaselines() throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(PluginImpl.getDescriptor().getCleartoolExe());
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[name]p ");
        if (this.promotionLevel != null && this.promotionLevel.length() > 0) {
            cmd.add("-level");
            cmd.add(this.promotionLevel);
        }
        cmd.add("-component");
        cmd.add(this.component + '@' + this.pvob);
        Hudson nodeRunningThisJob = Hudson.getInstance();
        for (Node node : Hudson.getInstance().getNodes()) {
            List jobs;
            Computer computer = node.toComputer();
            if (computer == null || (jobs = computer.getTiedJobs()) == null) continue;
            boolean nodeRunningThisJobFound = false;
            for (AbstractProject project : jobs) {
                ClearCaseUcmBaselineParameterDefinition pd;
                ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
                if (property == null || (pd = (ClearCaseUcmBaselineParameterDefinition)property.getParameterDefinition(PARAMETER_NAME)) == null || pd.compareTo(this) != 0) continue;
                nodeRunningThisJob = node;
                nodeRunningThisJobFound = true;
                break;
            }
            if (!nodeRunningThisJobFound) continue;
            break;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        nodeRunningThisJob.createLauncher(TaskListener.NULL).launch().cmds(cmd).stdout((OutputStream)baos).join();
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        if (cleartoolOutput.toString().contains("cleartool: Error")) {
            return null;
        }
        return cleartoolOutput.toString().split(" ");
    }

    public String getComponent() {
        return this.component;
    }

    public boolean getForceRmview() {
        return this.forceRmview;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public String getPvob() {
        return this.pvob;
    }

    public String getRestrictions() {
        return this.restrictions;
    }

    public List<String> getRestrictionsAsList() {
        ArrayList<String> restrictionsAsList = new ArrayList<String>();
        if (this.getRestrictions() != null && this.getRestrictions().length() > 0) {
            for (String restriction : Util.tokenize((String)this.getRestrictions(), (String)"\n\r\f")) {
                restrictionsAsList.add(restriction);
            }
        }
        return restrictionsAsList;
    }

    public boolean getSnapshotView() {
        return this.snapshotView;
    }

    public String getViewName() {
        return this.viewName;
    }

    @Override
    public int compareTo(ClearCaseUcmBaselineParameterDefinition pd) {
        if (pd.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }

    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public FormValidation doCheckComponent(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("ComponentMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPromotionLevel(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("PromotionLevelShouldBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPvob(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("PVOBMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckViewName(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("ViewNameMustBeSet", new Object[0]));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(ClearCaseUcmBaselineParameterDefinition.class).format("DisplayName", new Object[0]);
        }
    }
}

