/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineSCM;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineUtils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.plugins.clearcase.ClearToolExec;
import hudson.plugins.clearcase.ClearToolLauncher;
import hudson.plugins.clearcase.util.PathUtil;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;

public class ClearToolUcmBaseline
extends ClearToolExec {
    private transient Map<String, String> componentsCache = new Hashtable<String, String>();
    private transient Map<String, String> componentRootDirsCache = new Hashtable<String, String>();
    private transient Map<String, String[]> dependentBaselinesCache = new Hashtable<String, String[]>();

    public ClearToolUcmBaseline(VariableResolver variableResolver, ClearToolLauncher launcher) {
        super(variableResolver, launcher);
    }

    public String getComponentFromBaseline(String pvob, String baseline) throws IOException, InterruptedException {
        String baselineSelector = baseline + '@' + pvob;
        if (this.componentsCache.containsKey(baselineSelector)) {
            return this.componentsCache.get(baselineSelector);
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[component]p");
        cmd.add(baselineSelector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        if (cleartoolOutput.contains("cleartool: Error")) {
            this.launcher.getListener().error("Failed to get component from the baseline " + baselineSelector + ".");
            throw new IOException("Failed to get the component from the baseline " + baselineSelector + ": " + cleartoolOutput);
        }
        this.componentsCache.put(baselineSelector, cleartoolOutput);
        return cleartoolOutput;
    }

    public String getComponentRootDir(String pvob, String component) throws IOException, InterruptedException {
        String componentSelector = component + '@' + pvob;
        if (this.componentRootDirsCache.containsKey(componentSelector)) {
            return this.componentRootDirsCache.get(componentSelector);
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("lscomp");
        cmd.add("-fmt");
        cmd.add("%[root_dir]p");
        cmd.add(componentSelector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        if (cleartoolOutput.contains("cleartool: Error")) {
            this.launcher.getListener().error("Failed to get root dir of the component " + componentSelector + ".");
            throw new IOException("Failed to get the root dir of the component " + componentSelector + ": " + cleartoolOutput);
        }
        this.componentRootDirsCache.put(componentSelector, cleartoolOutput);
        return cleartoolOutput;
    }

    public String[] getDependentBaselines(String pvob, String baseline) throws IOException, InterruptedException {
        String baselineSelector = baseline + '@' + pvob;
        if (this.dependentBaselinesCache.containsKey(baselineSelector)) {
            return this.dependentBaselinesCache.get(baselineSelector);
        }
        String[] dependentBaselines = null;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.clear();
        cmd.add("lsbl");
        cmd.add("-fmt");
        cmd.add("%[depends_on_closure]p");
        cmd.add(baselineSelector);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        if (cleartoolOutput.contains("cleartool: Error")) {
            this.launcher.getListener().error("Failed to get the dependent baselines from the baseline " + baselineSelector + ".");
            throw new IOException("Failed to get the dependent baselines from the baseline " + baselineSelector + ": " + cleartoolOutput);
        }
        dependentBaselines = cleartoolOutput.length() > 0 ? cleartoolOutput.split(" ") : new String[]{};
        this.dependentBaselinesCache.put(baselineSelector, dependentBaselines);
        return dependentBaselines;
    }

    protected FilePath getRootViewPath(ClearToolLauncher launcher) {
        return launcher.getWorkspace();
    }

    public void update(String viewName, String loadRules) throws IOException, InterruptedException {
        this.unsupportedMethod(Thread.currentThread().getStackTrace()[0]);
    }

    public void rmview(String viewName) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("rmview");
        cmd.add("-force");
        cmd.add(viewName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        if (cleartoolOutput.contains("cleartool: Error")) {
            this.launcher.getListener().error("Failed to remove view " + viewName + ".");
            throw new IOException("Failed to remove view " + viewName + ": " + cleartoolOutput);
        }
        FilePath viewFilePath = this.launcher.getWorkspace().child(viewName);
        if (viewFilePath.exists()) {
            this.launcher.getListener().getLogger().println("View folder was not actually removed by \"cleartool rmview\"; Removing it now...");
            viewFilePath.deleteRecursive();
        }
    }

    public void rmviewtag(String viewName) throws IOException, InterruptedException {
        this.unsupportedMethod(Thread.currentThread().getStackTrace()[0]);
    }

    public void mkview(String viewName, String streamSelector) throws IOException, InterruptedException {
        this.mkview(viewName, true, null);
    }

    public void mkview(String viewName, boolean snapshotView, String streamSelector) throws IOException, InterruptedException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("mkview");
        if (snapshotView) {
            cmd.add("-snapshot");
        }
        cmd.add("-tag");
        cmd.add(viewName);
        cmd.add(viewName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, null);
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        if (cleartoolOutput.contains("cleartool: Error")) {
            this.launcher.getListener().error("Failed to create view " + viewName + ".");
            throw new IOException("Failed to create view " + viewName + ": " + cleartoolOutput);
        }
    }

    public void mkview(String string, String string1, String string2) throws IOException, InterruptedException {
        this.unsupportedMethod(Thread.currentThread().getStackTrace()[0]);
    }

    public void setcs(String viewName, String configSpec) throws IOException, InterruptedException {
        FilePath workspace = this.launcher.getWorkspace();
        FilePath configSpecFile = workspace.createTextTempFile("configspec", ".txt", configSpec);
        String configSpecLocation = ".." + File.separatorChar + configSpecFile.getName();
        configSpecLocation = PathUtil.convertPathForOS((String)configSpecLocation, (Launcher)this.launcher.getLauncher());
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("setcs");
        cmd.add("-tag");
        cmd.add(viewName);
        cmd.add(configSpecLocation);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.launcher.run(cmd.toCommandArray(), null, (OutputStream)baos, workspace.child(viewName));
        String cleartoolOutput = ClearCaseUcmBaselineUtils.processCleartoolOuput(baos);
        baos.close();
        configSpecFile.delete();
        if (cleartoolOutput.contains("cleartool: Error")) {
            this.launcher.getListener().error("Failed to set the config spec of the view " + viewName + ".");
            throw new IOException("Failed to set the config spec of the view " + viewName + ": " + cleartoolOutput);
        }
    }

    public void startView(String viewTags) throws IOException, InterruptedException {
        this.unsupportedMethod(Thread.currentThread().getStackTrace()[0]);
    }

    public void syncronizeViewWithStream(String viewName, String stream) throws IOException, InterruptedException {
        this.unsupportedMethod(Thread.currentThread().getStackTrace()[0]);
    }

    private void unsupportedMethod(StackTraceElement ste) {
        throw new UnsupportedOperationException(ClearCaseUcmBaselineSCM.class.getName() + " does not support the " + ste.getMethodName() + " method.");
    }
}

