/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.clearcaseucmbaseline;

import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineSCM;
import com.michelin.cio.hudson.plugins.clearcaseucmbaseline.ClearCaseUcmBaselineUtils;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.plugins.clearcase.ucm.UcmMakeBaseline;
import hudson.plugins.clearcase.ucm.UcmMakeBaselineComposite;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearCaseUcmBaselineParameterValue
extends ParameterValue {
    @Exported(visibility=3)
    private String baseline;
    @Exported(visibility=3)
    private String component;
    @Exported(visibility=3)
    private boolean forceRmview;
    @Exported(visibility=3)
    private String promotionLevel;
    @Exported(visibility=3)
    private String pvob;
    private List<String> restrictions;
    @Exported(visibility=3)
    private boolean snapshotView;
    @Exported(visibility=3)
    private String stream;
    @Exported(visibility=3)
    private boolean useUpdate;
    @Exported(visibility=3)
    private String viewName;
    private StringBuffer fatalErrorMessage = new StringBuffer();

    @DataBoundConstructor
    public ClearCaseUcmBaselineParameterValue(String name, String baseline, boolean forceRmview) {
        this(name, null, null, null, null, null, baseline, false, forceRmview, false);
    }

    public ClearCaseUcmBaselineParameterValue(String name, String pvob, String component, String promotionLevel, String stream, String viewName, String baseline, boolean useUpdate, boolean forceRmview, boolean snapshotView) {
        super(name);
        this.pvob = ClearCaseUcmBaselineUtils.prefixWithSeparator((String)pvob);
        this.component = component;
        this.promotionLevel = promotionLevel;
        this.stream = stream;
        this.viewName = viewName;
        this.baseline = baseline;
        this.useUpdate = useUpdate;
        this.forceRmview = forceRmview;
        this.snapshotView = snapshotView;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (this.baseline == null || this.baseline.length() == 0) {
            this.fatalErrorMessage.append("The value '" + this.baseline + "' is not a valid ClearCase UCM baseline.");
        }
        DescribableList publishersList = build.getProject().getPublishersList();
        for (Publisher publisher : publishersList) {
            if (!(publisher instanceof UcmMakeBaseline) && !(publisher instanceof UcmMakeBaselineComposite)) continue;
            if (this.fatalErrorMessage.length() > 0) {
                this.fatalErrorMessage.append('\n');
            }
            this.fatalErrorMessage.append("This job is set up to use a '").append(publisher.getDescriptor().getDisplayName()).append("' publisher which is not compatible with the ClearCase UCM baseline SCM mode. Please remove this publisher.");
        }
        if (this.fatalErrorMessage.length() > 0) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (build.getProject().getScm() instanceof ClearCaseUcmBaselineSCM) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String getBaseline() {
        return this.baseline;
    }

    public void setBaseline(String baseline) {
        this.baseline = baseline;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public boolean getForceRmview() {
        return this.forceRmview;
    }

    public void setForceRmview(boolean forceRmview) {
        this.forceRmview = forceRmview;
    }

    public String getPromotionLevel() {
        return this.promotionLevel;
    }

    public void setPromotionLevel(String promotionLevel) {
        this.promotionLevel = promotionLevel;
    }

    public String getPvob() {
        return this.pvob;
    }

    public void setPvob(String pvob) {
        this.pvob = pvob;
    }

    public void setRestrictions(List<String> restrictions) {
        this.restrictions = restrictions;
    }

    public boolean getSnapshotView() {
        return this.snapshotView;
    }

    public void setSnapshotView(boolean snapshotView) {
        this.snapshotView = snapshotView;
    }

    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public boolean getUseUpdate() {
        return this.useUpdate;
    }

    public void setUseUpdate(boolean useUpdate) {
        this.useUpdate = useUpdate;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    static /* synthetic */ StringBuffer access$000(ClearCaseUcmBaselineParameterValue x0) {
        return x0.fatalErrorMessage;
    }

    static /* synthetic */ String access$102(ClearCaseUcmBaselineParameterValue x0, String x1) {
        x0.viewName = x1;
        return x0.viewName;
    }

    static /* synthetic */ String access$100(ClearCaseUcmBaselineParameterValue x0) {
        return x0.viewName;
    }

    static /* synthetic */ String access$200(ClearCaseUcmBaselineParameterValue x0) {
        return x0.pvob;
    }

    static /* synthetic */ String access$300(ClearCaseUcmBaselineParameterValue x0) {
        return x0.component;
    }

    static /* synthetic */ boolean access$400(ClearCaseUcmBaselineParameterValue x0) {
        return x0.forceRmview;
    }

    static /* synthetic */ String access$500(ClearCaseUcmBaselineParameterValue x0) {
        return x0.baseline;
    }

    static /* synthetic */ boolean access$600(ClearCaseUcmBaselineParameterValue x0) {
        return x0.useUpdate;
    }

    static /* synthetic */ boolean access$700(ClearCaseUcmBaselineParameterValue x0) {
        return x0.snapshotView;
    }

    static /* synthetic */ List access$800(ClearCaseUcmBaselineParameterValue x0) {
        return x0.restrictions;
    }
}

